/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.accessors.BlockAccessor;
import net.blockomorph.utils.config.Config;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockmorphCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blockmorph").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(arguments -> {
            SavedBlock block = BlockmorphCommand.getBlockForPos((CommandContext<CommandSourceStack>)arguments);
            return BlockmorphCommand.morphMany((CommandSourceStack)arguments.getSource(), block.getState(), EntityArgument.m_91477_((CommandContext)arguments, (String)"targets"), block.getTag());
        }))).executes(arguments -> {
            SavedBlock block = BlockmorphCommand.getBlockForPos((CommandContext<CommandSourceStack>)arguments);
            return BlockmorphCommand.morphSingle((CommandSourceStack)arguments.getSource(), block.getState(), ((CommandSourceStack)arguments.getSource()).m_81375_(), block.getTag());
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(arguments -> BlockmorphCommand.morphMany((CommandSourceStack)arguments.getSource(), BlockStateArgument.m_116123_((CommandContext)arguments, (String)"block").m_114669_(), EntityArgument.m_91477_((CommandContext)arguments, (String)"targets"), BlockAccessor.of(BlockStateArgument.m_116123_((CommandContext)arguments, (String)"block")).getTag())))).executes(arguments -> BlockmorphCommand.morphSingle((CommandSourceStack)arguments.getSource(), BlockStateArgument.m_116123_((CommandContext)arguments, (String)"block").m_114669_(), ((CommandSourceStack)arguments.getSource()).m_81375_(), BlockAccessor.of(BlockStateArgument.m_116123_((CommandContext)arguments, (String)"block")).getTag()))));
    }

    private static SavedBlock getBlockForPos(CommandContext<CommandSourceStack> arguments) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(arguments, (String)"pos");
        ServerLevel level = ((CommandSourceStack)arguments.getSource()).m_81372_();
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag tag = null;
        if (blockEntity != null) {
            try {
                tag = blockEntity.m_187482_();
            }
            catch (Throwable e) {
                ((CommandSourceStack)arguments.getSource()).m_81352_((Component)Component.m_237113_((String)(e.getMessage() != null ? e.getMessage() : e.getClass().getName())));
            }
        }
        return new SavedBlock(blockState, tag, null);
    }

    private static int morphMany(CommandSourceStack stack, BlockState blockstate, Collection<ServerPlayer> players, CompoundTag tag) throws CommandSyntaxException {
        if (BlockmorphCommand.checkConfig(stack)) {
            return 0;
        }
        BannedBlock global = BannedBlock.isBannedBlock(blockstate, null, BannedBlock.Source.COMMAND);
        if (global != null) {
            stack.m_81352_(global.text());
            return 0;
        }
        int success = 0;
        for (ServerPlayer entity : players) {
            PlayerAccessor pl;
            BannedBlock reason;
            if (!(entity instanceof PlayerAccessor) || (reason = (pl = (PlayerAccessor)entity).applyBlockMorph(blockstate, tag, BannedBlock.Source.COMMAND)) != null) continue;
            ++success;
        }
        if (success == 0) {
            throw EntityArgument.f_91440_.create();
        }
        int result = success;
        stack.m_288197_(() -> Component.m_237110_((String)"blockomorph.morphCommand.many", (Object[])new Object[]{result, blockstate.m_60734_().m_49954_()}), true);
        return players.size();
    }

    private static int morphSingle(CommandSourceStack stack, BlockState blockstate, ServerPlayer player, CompoundTag tag) {
        if (BlockmorphCommand.checkConfig(stack)) {
            return 0;
        }
        BannedBlock reason = PlayerAccessor.of((Player)player).applyBlockMorph(blockstate, tag, BannedBlock.Source.COMMAND);
        if (reason != null) {
            stack.m_81352_(reason.text());
            return 0;
        }
        stack.m_288197_(() -> Component.m_237110_((String)"blockomorph.morphCommand.single", (Object[])new Object[]{blockstate.m_60734_().m_49954_()}), true);
        return 1;
    }

    private static boolean checkConfig(CommandSourceStack stack) {
        if (Config.getInstance() == null) {
            stack.m_81352_((Component)Component.m_237113_((String)"Config not loaded, something works like that... :/"));
            return true;
        }
        return false;
    }
}

