/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.core;

import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.blockomorph.screens.config.ConfigScreen;
import net.blockomorph.screens.morph.MorphScreen;
import net.blockomorph.screens.morphConfig.MorphConfigScreen;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class KeyMappings {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final ArrayList<KeyMapping> KEYS = new ArrayList();
    public static final KeyMapping MORPH = new HandlerKeymapping("morph_menu", 89, () -> {
        Config.ScreenAccess access = MorphUtils.getScreenAccess((Player)KeyMappings.mc.f_91074_);
        if (access.morph) {
            mc.m_91152_((Screen)new MorphScreen(true, true).ignoreInitInput());
            return true;
        }
        return false;
    });
    public static final KeyMapping MORPH_CONFIG = new HandlerKeymapping("morph_config_menu", 85, () -> {
        Config.ScreenAccess access = MorphUtils.getScreenAccess((Player)KeyMappings.mc.f_91074_);
        if (access.config && KeyMappings.mc.f_91074_ != null) {
            BlockState blockState = PlayerAccessor.of((Player)KeyMappings.mc.f_91074_).getBlockState(InPlayerBlockPos.ZERO);
            if (BannedBlock.isBannedBlock(blockState, PlayerAccessor.of((Player)KeyMappings.mc.f_91074_), BannedBlock.Source.NETWORK) != null) {
                return false;
            }
            mc.m_91152_((Screen)new MorphConfigScreen());
            return true;
        }
        return false;
    });
    public static final KeyMapping CONFIG = new HandlerKeymapping("config_menu", 78, () -> {
        if (MorphUtils.canOpenConfig()) {
            mc.m_91152_((Screen)new ConfigScreen());
            return true;
        }
        return false;
    });

    public static void registerKeyMappings(Consumer<KeyMapping> register) {
        for (KeyMapping key : KEYS) {
            register.accept(key);
        }
    }

    private static class HandlerKeymapping
    extends KeyMapping {
        private final BooleanSupplier action;

        public HandlerKeymapping(String lang, int key, BooleanSupplier action) {
            super("blockomorph.key." + lang, key, "key.categories.ui");
            KEYS.add(this);
            this.action = action;
        }

        public void m_7249_(boolean isDown) {
            super.m_7249_(isDown);
            if (isDown && KeyMappings.mc.f_91080_ == null && !this.action.getAsBoolean() && KeyMappings.mc.f_91073_ != null) {
                GuiUtils.pushHotbarMessage((Component)Component.m_237115_((String)(this.m_90860_() + ".error")).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

