/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.blockomorph.network.ClientBoundEntityDataSyncPacket;
import net.blockomorph.utils.dataSyncher.AutoSyncedEntityData;
import net.blockomorph.utils.dataSyncher.SyncedEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Entity.class}, priority=1030)
public abstract class EntityDataSupportMixin
implements SyncedEntity {
    @Shadow
    private int f_19848_;
    private List<AutoSyncedEntityData<?>> SYNCERS;
    private boolean dirty;

    @Override
    public void registerDataSyncer(AutoSyncedEntityData<?> data) {
        if (this.getDataById(data.getId()) != null) {
            throw new IllegalArgumentException("Data with id: " + this.f_19848_ + " already registered!");
        }
        this.get().add(data);
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public void checkOrSendImmediate(Consumer<ClientBoundEntityDataSyncPacket> doing, boolean force) {
        if (!this.dirty && !force) {
            return;
        }
        for (AutoSyncedEntityData<?> data : this.get()) {
            if (!data.isDirty() && !force) continue;
            doing.accept(new ClientBoundEntityDataSyncPacket(this, data));
        }
        this.dirty = false;
    }

    @Override
    @Nullable
    public AutoSyncedEntityData<?> getDataById(ResourceLocation id) {
        for (AutoSyncedEntityData<?> data : this.get()) {
            if (!data.getId().equals((Object)id)) continue;
            return data;
        }
        return null;
    }

    private List<AutoSyncedEntityData<?>> get() {
        if (this.SYNCERS == null) {
            this.SYNCERS = new ArrayList();
        }
        return this.SYNCERS;
    }
}

