/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.Optional;
import javax.annotation.Nullable;
import net.blockomorph.utils.ChairController;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=1020)
public abstract class EntityMixin
implements EntityAccessor {
    @Shadow
    private Level f_19853_;
    @Unique
    private Vec3 fromMorphedPos;
    private final ChairController CHAIR_CONTROLLER = new ChairController((Entity)this);
    @Unique
    private Vec3 tempPos;
    @Unique
    private Vec3 tpPos;

    @Shadow
    public abstract boolean m_20363_(Entity var1);

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract boolean m_7998_(Entity var1, boolean var2);

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract Vec3 m_20182_();

    @Override
    public Vec3 getMorphedPos() {
        return this.fromMorphedPos;
    }

    @Override
    @Nullable
    public Vec3 getSyncedPos() {
        CompoundTag tg = this.CHAIR_CONTROLLER.getTagData();
        if (!tg.m_128456_()) {
            Vec3 vec = new Vec3(tg.m_128459_("x"), tg.m_128459_("y"), tg.m_128459_("z"));
            return InPlayerBlockPos.checkOnReal(vec);
        }
        return null;
    }

    @Inject(method={"distanceToSqr(DDD)D"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRealCoordsSqr(double x, double y, double z, CallbackInfoReturnable<Double> cir) {
        MorphUtils.distanceTo(new Vec3(x, y, z), ((Entity)this).m_20182_(), true, 0.0, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"distanceToSqr(Lnet/minecraft/world/phys/Vec3;)D"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRealCoordsVec3(Vec3 pos, CallbackInfoReturnable<Double> cir) {
        MorphUtils.distanceTo(pos, ((Entity)this).m_20182_(), true, 0.0, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getBoundingBoxForPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRealPos(Pose pose, CallbackInfoReturnable<AABB> cir) {
        PlayerAccessor pl;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)entityMixin)).isFullActive()) {
            cir.setReturnValue((Object)this.m_6972_(pose).m_20393_(this.m_20182_()));
        }
    }

    @Inject(method={"isAttackable"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkAccess(CallbackInfoReturnable<Boolean> cir) {
        PlayerAccessor pl;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            return;
        }
        EntityMixin entityMixin = this;
        if (entityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)entityMixin)).isActive()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")})
    public void redirect(double x, double y, double z, CallbackInfo ci) {
        Vec3 vec = new Vec3(x, y, z);
        this.tempPos = InPlayerBlockPos.checkOnReal(vec);
        if (!this.tempPos.equals((Object)vec)) {
            this.fromMorphedPos = vec;
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void correctPos(Entity passanger, Entity.MoveFunction setPosition, CallbackInfo ci) {
        if (this.m_20363_(passanger)) {
            EntityAccessor acc;
            Vec3 vec3;
            if (passanger instanceof EntityAccessor && (vec3 = (acc = (EntityAccessor)passanger).getSyncedPos()) != null) {
                setPosition.m_20372_(passanger, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                ci.cancel();
            } else if (passanger instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)passanger;
                Optional pos = livingEntity.m_21257_();
                pos.ifPresent(blockpos -> {
                    if (InPlayerBlockPos.isMorphedPlayerX(blockpos.m_123341_())) {
                        Vec3 bedPos = InPlayerBlockPos.checkOnReal(Vec3.m_82512_((Vec3i)blockpos));
                        setPosition.m_20372_(passanger, bedPos.f_82479_, bedPos.f_82480_ + 0.0625, bedPos.f_82481_);
                        ci.cancel();
                    }
                });
            }
        }
    }

    @Inject(method={"setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectInvalidMovement(Vec3 vec3, CallbackInfo ci) {
        if (this instanceof Projectile && (vec3.f_82479_ > 2.9999995E7 || vec3.f_82481_ > 2.9999995E7 || vec3.f_82481_ < -2.9999995E7)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.CHAIR_CONTROLLER.tick();
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    public void stopRiding(CallbackInfo ci) {
        this.CHAIR_CONTROLLER.onStopRiding();
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPose(Lnet/minecraft/world/entity/Pose;)V")}, cancellable=true)
    public void startRidingCheck(Entity entity, boolean p_19967_, CallbackInfoReturnable<Boolean> cir) {
        Entity ent = this.CHAIR_CONTROLLER.replaceEntityOnMorphedPlayer(entity);
        if (ent != entity) {
            cir.setReturnValue((Object)true);
            this.m_7998_(ent, true);
        }
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.tempPos.f_82479_;
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.tempPos.f_82480_;
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.tempPos.f_82481_;
    }

    @Inject(method={"absMoveTo(DDD)V"}, at={@At(value="HEAD")})
    public void redirectTp(double x, double y, double z, CallbackInfo ci) {
        this.tpPos = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=0)
    public double getXtp(double value) {
        return this.tpPos.f_82479_;
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=1)
    public double getYtp(double value) {
        return this.tpPos.f_82480_;
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=2)
    public double getZtp(double value) {
        return this.tpPos.f_82481_;
    }

    @Override
    public void forceLevelChange(Level lv) {
        this.f_19853_ = lv;
    }
}

