/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.AbstractMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.fluids.FluidType;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class FluidEntitySupportMixin
implements IForgeEntity {
    @Shadow
    private Level f_19853_;
    @Shadow
    @Final
    private Set<TagKey<Fluid>> f_19801_;

    @Shadow
    protected abstract void m_6763_(BlockState var1);

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract Vec3 m_146892_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    public abstract void m_20256_(Vec3 var1);

    @Shadow(remap=false)
    protected abstract void setFluidTypeHeight(FluidType var1, double var2);

    @Inject(at={@At(value="TAIL")}, method={"checkInsideBlocks"})
    private void checkInsideBlocks(CallbackInfo ci) {
        if (Config.getInstance().getValue("entityInside", Boolean.class).booleanValue()) {
            AABB entityBox = this.m_20191_().m_82406_((double)1.0E-5f);
            Entity self = (Entity)this;
            List entities = this.f_19853_.m_6249_(self, entityBox, EntitySelector.f_20408_);
            for (Entity entity : entities) {
                PlayerAccessor pl;
                if (!(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive()) continue;
                pl.getBlocksData2InArea(entityBox, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(pos, block, realPos) -> {
                    BlockState blockState = block.getBlockState();
                    if (!blockState.m_60795_()) {
                        blockState.m_60682_(this.f_19853_, block.getPos(), self);
                        this.m_6763_(blockState);
                    }
                }));
            }
        }
    }

    @Inject(remap=false, method={"updateFluidHeightAndDoFluidPushing(Ljava/util/function/Predicate;)V"}, at={@At(value="TAIL")})
    public void calculateInFluid2(Predicate<FluidState> shouldUpdate, CallbackInfo ci) {
        Object2ObjectArrayMap calcs = new Object2ObjectArrayMap();
        AABB aabb = this.m_20191_().m_82406_(0.001);
        List entities = this.f_19853_.m_6249_((Entity)this, aabb, EntitySelector.f_20408_);
        for (Entity entity : entities) {
            PlayerAccessor pl;
            if (!(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive()) continue;
            pl.getBlocksData2InArea(aabb, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(arg_0, arg_1, arg_2) -> this.lambda$calculateInFluid2$2(shouldUpdate, aabb, (Object2ObjectMap)calcs, arg_0, arg_1, arg_2)));
        }
        this.calculateLiquidsPower((Object2ObjectMap<FluidType, Object[]>)calcs);
    }

    @Unique
    private void calculateLiquidsPower(Object2ObjectMap<FluidType, Object[]> map) {
        map.forEach((fluidType, objects) -> {
            double fluidHeight = (Double)objects[0];
            Vec3 flow = (Vec3)objects[1];
            int count = (Integer)objects[2];
            if (flow.m_82553_() > 0.0) {
                if (count > 0) {
                    flow = flow.m_82490_(1.0 / (double)count);
                }
                if (!(this instanceof Player)) {
                    flow = flow.m_82541_();
                }
                Vec3 vec32 = this.m_20184_();
                flow = flow.m_82490_(this.getFluidMotionScale((FluidType)fluidType));
                double d2 = 0.003;
                if (Math.abs(vec32.f_82479_) < d2 && Math.abs(vec32.f_82481_) < d2 && flow.m_82553_() < 0.0045000000000000005) {
                    flow = flow.m_82541_().m_82490_(0.0045000000000000005);
                }
                this.m_20256_(this.m_20184_().m_82549_(flow));
            }
            this.setFluidTypeHeight((FluidType)fluidType, fluidHeight);
        });
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="TAIL")})
    public void getLiquid(CallbackInfo ci) {
        FluidState fluidState;
        double height;
        BlockInPlayer2 block;
        double y;
        AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> liquid = this.getLiquid(this.m_146892_());
        if (liquid != null && (y = MorphUtils.getRealBlockPos((PlayerAccessor)liquid.getKey(), (InPlayerBlockPos)block.getOffset()).f_82480_) + (height = (double)(fluidState = (block = liquid.getValue()).getBlockState().m_60819_()).m_76155_((BlockGetter)this.f_19853_, block.getPos())) > this.m_20188_()) {
            fluidState.m_205075_().forEach(tag -> this.f_19801_.add((TagKey<Fluid>)tag));
        }
    }

    @Unique
    private AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> getLiquid(Vec3 position) {
        Entity self = (Entity)this;
        AtomicReference reference = new AtomicReference();
        List entities = this.f_19853_.m_6249_(self, new AABB(BlockPos.f_121853_).m_82383_(position.m_82520_(-0.5, -0.5, -0.5)), EntitySelector.f_20408_);
        MorphUtils.doBlockInMorphedPlayerOnPos(self, entities, position, (pl, block) -> {
            if (block.shouldDoFluidAction()) {
                reference.set(new AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2>((PlayerAccessor)pl, (BlockInPlayer2)block));
            }
        });
        return (AbstractMap.SimpleEntry)reference.get();
    }

    private /* synthetic */ void lambda$calculateInFluid2$2(Predicate shouldUpdate, AABB aabb, Object2ObjectMap calcs, InPlayerBlockPos pos, BlockInPlayer2 block, Vec3 realPos) {
        if (block.shouldDoFluidAction()) {
            FluidState fluidState = block.getBlockState().m_60819_();
            FluidType type = fluidState.getFluidType();
            double fluidHeight = realPos.f_82480_ + (double)fluidState.m_76155_((BlockGetter)this.f_19853_, block.getPos());
            if (shouldUpdate.test(fluidState) && fluidHeight >= aabb.f_82289_) {
                Object[] list = (Object[])calcs.computeIfAbsent((Object)type, o -> {
                    Object[] objs = new Object[]{0.0, Vec3.f_82478_, 0};
                    return objs;
                });
                list[0] = Math.max(fluidHeight - aabb.f_82289_, (Double)list[0]);
                if (this.isPushedByFluid(type)) {
                    Vec3 flowSpeed = fluidState.m_76179_((BlockGetter)this.f_19853_, block.getPos());
                    if ((Double)list[0] < 0.4) {
                        flowSpeed = flowSpeed.m_82490_(((Double)list[0]).doubleValue());
                    }
                    list[1] = ((Vec3)list[1]).m_82549_(flowSpeed);
                    list[2] = (Integer)list[2] + 1;
                }
            }
        }
    }
}

