/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import net.blockomorph.utils.PlayerAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="RETURN")}, cancellable=true)
    public void checkSeen(CallbackInfoReturnable<Boolean> cir) {
        PlayerAccessor pl;
        boolean result = (Boolean)cir.getReturnValue();
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)livingEntityMixin)).isActive()) {
            cir.setReturnValue((Object)false);
            return;
        }
        cir.setReturnValue((Object)result);
    }

    @Inject(method={"push"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectPush(Entity entity, CallbackInfo ci) {
        PlayerAccessor pl;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)livingEntityMixin)).isActive()) {
            ci.cancel();
        }
    }

    @Inject(method={"pushEntities"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectPushEntities(CallbackInfo ci) {
        PlayerAccessor pl;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)livingEntityMixin)).isActive()) {
            ci.cancel();
        }
    }
}

