/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blockomorph.network.ClientBoundApplyBlockMorphPacket;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.network.ClientBoundServerBlockEntityTagPacket;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.HitBoxCalculator;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.MorphedPlayerRenderer;
import net.blockomorph.utils.MovementCalculator;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.tnt.TntHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerAccessor {
    @Shadow
    @Final
    private Abilities f_36077_;
    private final TntHandler TNT_HANDLER = new TntHandler(this);
    private final HitBoxCalculator HITBOX_HANDLER = new HitBoxCalculator(this);
    private final ConcurrentHashMap<InPlayerBlockPos, BlockInPlayer2> blocksData = new ConcurrentHashMap();
    private final Map<InPlayerBlockPos, BlockInPlayer2> unmodifiableBlocksData = Collections.unmodifiableMap(this.blocksData);
    private final List<InPlayerBlockPos> updates = new CopyOnWriteArrayList<InPlayerBlockPos>();
    private final ConcurrentHashMap<InPlayerBlockPos, BlockEventData> blocksEventsToTick = new ConcurrentHashMap();
    private boolean onLoadingBlocks;
    private boolean breakingMode;
    private boolean unContextedBreakingMode;

    @Override
    public boolean setBlockState(InPlayerBlockPos pos, BlockState state, boolean updateInternal) {
        if (state.m_60734_() == Blocks.f_50016_ && this.isBreaking() && InPlayerBlockPos.ZERO.equals(pos)) {
            this.setBlockState(pos, Blocks.f_50626_.m_49966_(), updateInternal);
        } else {
            BlockInPlayer2 old;
            if (pos == null || !pos.isValid() || (old = this.blocksData.get(pos)) != null && old.getBlockState() == state) {
                return false;
            }
            if (state.m_60734_() == Blocks.f_50016_) {
                BlockInPlayer2 block = this.blocksData.get(pos);
                if (block != null) {
                    block.changeBlockState(state, updateInternal);
                }
                this.blocksData.remove(pos);
            } else if (this.blocksData.containsKey(pos)) {
                this.blocksData.get(pos).changeBlockState(state, updateInternal);
            } else {
                BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
                block.onPlace(state, Blocks.f_50016_.m_49966_(), updateInternal);
            }
        }
        this.HITBOX_HANDLER.recalculatePositions();
        this.m_6210_();
        return true;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(InPlayerBlockPos pos) {
        if (this.blocksData == null) {
            return null;
        }
        BlockInPlayer2 bl = this.blocksData.get(pos);
        if (bl != null) {
            return bl.getBlockEntity();
        }
        return null;
    }

    @Override
    public CompoundTag getTag(InPlayerBlockPos pos) {
        BlockInPlayer2 ent = this.blocksData.get(pos);
        if (ent != null && ent.getBlockEntity() != null) {
            return ent.getBlockEntity().m_187482_();
        }
        return new CompoundTag();
    }

    @Override
    public BlockState getBlockState(InPlayerBlockPos pos) {
        if (this.blocksData == null) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockInPlayer2 bl = this.blocksData.get(pos);
        if (bl != null) {
            return bl.getBlockState();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public Map<InPlayerBlockPos, BlockInPlayer2> getBlocksData2() {
        return this.unmodifiableBlocksData;
    }

    @Override
    public void prepareSync(InPlayerBlockPos pos) {
        if (!this.m_9236_().f_46443_ && !this.updates.contains(pos)) {
            this.updates.add(pos);
        }
    }

    @Override
    public void prepareSync(InPlayerBlockPos pos, BlockEventData data) {
        if (!this.m_9236_().f_46443_ && !this.blocksEventsToTick.containsKey(pos)) {
            this.blocksEventsToTick.put(pos, data);
        }
    }

    @Override
    public void breakingModeStart(boolean yes) {
        this.unContextedBreakingMode = yes;
        if (Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue() || !yes) {
            this.breakingMode = yes;
        }
    }

    @Override
    public boolean isBreaking() {
        return this.breakingMode;
    }

    @Override
    public boolean isUnContextedBreaking() {
        return this.unContextedBreakingMode;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("BlockoMorph")) {
            this.loadBlockData(tag.m_128469_("BlockoMorph"), null, true);
        } else if (tag.m_128441_("BlockMorph")) {
            this.oldDataHandle(tag.m_128469_("BlockMorph"));
        }
    }

    @Override
    public void loadBlockData(CompoundTag blockomorph, @Nullable ClientBoundMorphUpdatePacket client, boolean first) {
        if (first) {
            this.blocksData.clear();
        }
        for (String key : blockomorph.m_128431_()) {
            InPlayerBlockPos pos = InPlayerBlockPos.parseBlockPos(key);
            if (pos == null) continue;
            CompoundTag tg = blockomorph.m_128469_(key);
            BlockState state = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tg.m_128469_("BlockState"));
            CompoundTag tags = tg.m_128469_("BlockEntityTag");
            BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
            if (client != null) {
                block.handleClientTag(tags, client);
                continue;
            }
            block.loadNBT(tags);
        }
        this.HITBOX_HANDLER.recalculatePositions();
        this.m_6210_();
    }

    @Override
    public CompoundTag saveBlockData(boolean client) {
        CompoundTag blocks = new CompoundTag();
        this.blocksData.forEach((pos, data) -> {
            try {
                CompoundTag tg = new CompoundTag();
                tg.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)data.getBlockState()));
                BlockEntity ent = data.getBlockEntity();
                CompoundTag blockTag = new CompoundTag();
                if (ent != null) {
                    CompoundTag servTag = ent.m_187482_();
                    blockTag = client ? ent.m_5995_() : servTag;
                }
                tg.m_128365_("BlockEntityTag", (Tag)blockTag);
                blocks.m_128365_(pos.string(), (Tag)tg);
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while saving morphed player data on pos: {} for block: {} on player: {}", new Object[]{pos, data.getBlockState(), this.m_7755_().getString(), e});
            }
        });
        return blocks;
    }

    @Override
    public boolean isOnLoadingBlocks() {
        return this.onLoadingBlocks;
    }

    @Override
    public void setOnLoadingBlocks(boolean yes) {
        this.onLoadingBlocks = yes;
    }

    private void oldDataHandle(CompoundTag tag) {
        if (!this.m_9236_().f_46443_) {
            BlockState state = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
            CompoundTag tags = tag.m_128469_("Tags");
            InPlayerBlockPos pos = InPlayerBlockPos.ZERO;
            BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
            block.loadNBT(tags);
            this.HITBOX_HANDLER.recalculatePositions();
            this.m_6210_();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        CompoundTag tg = this.saveBlockData(false);
        if (!tg.m_128456_()) {
            tag.m_128365_("BlockoMorph", (Tag)tg);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(Entity entity, CallbackInfo ci) {
        PlayerAccessor pl;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            return;
        }
        if (entity instanceof PlayerAccessor && (pl = (PlayerAccessor)entity).isActive()) {
            ci.cancel();
        }
    }

    @Inject(method={"updatePlayerPose"}, at={@At(value="HEAD")}, cancellable=true)
    public void updatePose(CallbackInfo ci) {
        this.m_21257_().ifPresent(pos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_()) && !this.m_20175_(Pose.SWIMMING)) {
                this.m_20124_(Pose.SLEEPING);
                ci.cancel();
            }
        });
    }

    @Override
    public void sendNearby(Packet<?> packet) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel lv = (ServerLevel)level;
            ServerChunkCache cache = lv.m_7726_();
            cache.m_8394_((Entity)this.player(), packet);
        }
    }

    @Override
    public List<InPlayerBlockPos> getUpdates() {
        return Collections.unmodifiableList(this.updates);
    }

    @Override
    public void getBlocksData2InArea(AABB box, TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3> action) {
        if (action != null && box != null && this.m_20191_().m_82381_(box)) {
            Vec3 realPos = MorphUtils.getRealBlockPos((PlayerAccessor)this, InPlayerBlockPos.ZERO);
            int minX = Mth.m_14107_((double)(box.f_82288_ - realPos.f_82479_));
            int minY = Mth.m_14107_((double)(box.f_82289_ - realPos.f_82480_));
            int minZ = Mth.m_14107_((double)(box.f_82290_ - realPos.f_82481_));
            int maxX = Mth.m_14107_((double)(box.f_82291_ - realPos.f_82479_));
            int maxY = Mth.m_14107_((double)(box.f_82292_ - realPos.f_82480_));
            int maxZ = Mth.m_14107_((double)(box.f_82293_ - realPos.f_82481_));
            for (int x = Math.max(-14, minX); x <= Math.min(14, maxX); ++x) {
                for (int y = Math.max(0, minY); y <= Math.min(30, maxY); ++y) {
                    for (int z = Math.max(-14, minZ); z <= Math.min(14, maxZ); ++z) {
                        InPlayerBlockPos pos = InPlayerBlockPos.get(x, y, z);
                        BlockInPlayer2 block = this.blocksData.get(pos);
                        if (block == null) continue;
                        action.accept((Object)pos, (Object)block, (Object)realPos.m_82549_(new Vec3((double)x, (double)y, (double)z)));
                    }
                }
            }
        }
    }

    @Override
    public void sendAllContentToPlayer(ServerPlayer target) {
        CompoundTag blocks = this.saveBlockData(true);
        CompoundTag buffer = new CompoundTag();
        ArrayList<ClientBoundMorphUpdatePacket> packets = new ArrayList<ClientBoundMorphUpdatePacket>();
        boolean first = true;
        for (String key : blocks.m_128431_()) {
            CompoundTag block = blocks.m_128469_(key);
            if (block.m_128456_()) continue;
            buffer.m_128365_(key, (Tag)block);
            if (buffer.m_263179_() <= 524288) continue;
            buffer.m_128473_(key);
            packets.add(new ClientBoundMorphUpdatePacket(this, buffer, first));
            first = false;
            buffer = new CompoundTag();
            buffer.m_128365_(key, (Tag)block);
        }
        packets.add(new ClientBoundMorphUpdatePacket(this, buffer, first));
        for (ClientBoundMorphUpdatePacket packet : packets) {
            MorphUtils.sendPlayer(packet, target);
        }
    }

    private void runUpdates() {
        if (this.updates.isEmpty()) {
            return;
        }
        this.updates.forEach(realPos -> {
            BlockInPlayer2 block = this.blocksData.get(realPos);
            if (block == null) {
                BlockPos pos = realPos.boundedBlockPos(this.player());
                if (pos != null) {
                    this.sendNearby((Packet<?>)new ClientboundBlockUpdatePacket(pos, Blocks.f_50016_.m_49966_()));
                }
            } else {
                this.sendBockData(block);
            }
        });
        this.updates.clear();
    }

    private void sendBockData(BlockInPlayer2 block) {
        this.sendNearby((Packet<?>)new ClientboundBlockUpdatePacket(block.getPos(), block.getBlockState()));
        BlockEntity ent = block.getBlockEntity();
        if (ent != null) {
            try {
                if (ent.m_58483_() != null) {
                    this.sendNearby(ent.m_58483_());
                }
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while sending morphed player data on pos: " + block.getOffset() + " for block: " + block.getBlockState() + " on player: " + this.m_7755_().getString(), (Throwable)e);
            }
        }
    }

    private void runUpdatesBlockEvents() {
        if (this.blocksEventsToTick.isEmpty()) {
            return;
        }
        this.blocksEventsToTick.forEach((realPos, data) -> {
            BlockInPlayer2 block = this.blocksData.get(realPos);
            if (block != null) {
                block.getBlockState().m_60677_(this.m_9236_(), data.f_45529_(), data.f_45531_(), data.f_45532_());
                this.sendNearby((Packet<?>)new ClientboundBlockEventPacket(data.f_45529_(), data.f_45530_(), data.f_45531_(), data.f_45532_()));
            }
        });
        this.blocksEventsToTick.clear();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    public void tick(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            this.runUpdates();
            this.runUpdatesBlockEvents();
        }
        if (this.isFullActive()) {
            ProfilerFiller profiler = this.m_9236_().m_46473_();
            profiler.m_6180_("blockInMorphedPlayerTick");
            for (BlockInPlayer2 block : this.blocksData.values()) {
                block.tick();
            }
            profiler.m_7238_();
        }
        this.TNT_HANDLER.tick();
        this.fluidCollisionUpdate();
    }

    private void fluidCollisionUpdate() {
        Block block;
        BlockState state = this.getBlockState(InPlayerBlockPos.ZERO);
        if (!this.f_36077_.f_35935_ && (block = state.m_60734_()) instanceof LiquidBlock) {
            LiquidBlock block2 = (LiquidBlock)block;
            if (this.m_9236_().m_8055_(this.m_20183_()).m_60734_() == block2) {
                Vec3 movement = this.m_20184_();
                this.m_20334_(movement.f_82479_, Math.min(1.8, movement.f_82480_ + 0.3), movement.f_82481_);
                this.m_183634_();
            }
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage(float f, float g, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.isActive()) {
            cir.cancel();
            if (!(this.getBlockState(InPlayerBlockPos.ZERO).m_60734_() instanceof AnvilBlock)) {
                return;
            }
            int i = Mth.m_14167_((float)(f - 1.0f));
            if (i < 0) {
                return;
            }
            Predicate predicate = EntitySelector.f_20406_.and(EntitySelector.f_20403_);
            DamageSource damageSource22 = this.m_269291_().m_269230_((Entity)this);
            float h = Math.min(Mth.m_14143_((float)((float)i * 2.0f)), 40);
            this.m_9236_().m_6249_((Entity)this, this.m_20191_(), predicate).forEach(entity -> entity.m_6469_(damageSource22, h));
        }
    }

    @Override
    @Nullable
    public BannedBlock applyBlockMorph(BlockState state, CompoundTag tag, BannedBlock.Source source) {
        InPlayerBlockPos pos2;
        BannedBlock mess = BannedBlock.isBannedBlock(state, this, source);
        if (mess != null) {
            return mess;
        }
        BlockState old = this.getBlockState(InPlayerBlockPos.ZERO);
        boolean flag = state.equals(old);
        if (tag == null && flag) {
            return BannedBlock.ALREADY_MORPHED;
        }
        MorphUtils.sendPlayer(new ClientBoundApplyBlockMorphPacket(state, this), (ServerPlayer)this.player());
        this.onLoadingBlocks = true;
        for (InPlayerBlockPos pos2 : this.blocksData.keySet()) {
            if (pos2.equals(InPlayerBlockPos.ZERO)) continue;
            this.setBlockState(pos2, Blocks.f_50016_.m_49966_(), false);
            this.updates.add(pos2);
        }
        this.setBlockState(InPlayerBlockPos.ZERO, state, false);
        BlockInPlayer2 block = this.blocksData.get(InPlayerBlockPos.ZERO);
        if (block != null && tag != null) {
            Throwable e = block.loadNBT(tag);
            ServerPlayer serverPlayer = (ServerPlayer)this.player();
            if (e != null) {
                MorphUtils.sendPlayer(ClientBoundServerBlockEntityTagPacket.createForError(Objects.requireNonNullElse(e.getMessage(), e.getClass().getName()), true), serverPlayer);
            } else {
                CompoundTag newTag = this.getTag(InPlayerBlockPos.ZERO);
                if (!newTag.equals((Object)tag)) {
                    MorphUtils.sendPlayer(ClientBoundServerBlockEntityTagPacket.createForError("", false), serverPlayer);
                }
            }
        }
        if ((pos2 = InPlayerBlockPos.ZERO.boundedBlockPos(this.player())) != null) {
            state.m_60734_().m_6402_(this.m_9236_(), (BlockPos)pos2, state, (LivingEntity)this, new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1));
        }
        this.updates.add(InPlayerBlockPos.ZERO);
        this.runUpdates();
        this.onLoadingBlocks = false;
        if (!this.m_9236_().f_46443_) {
            this.TNT_HANDLER.stopRunning();
        }
        return null;
    }

    @Override
    public PrimedTnt getTnt() {
        return this.TNT_HANDLER.getTnt();
    }

    @Override
    public void setTnt() {
        this.TNT_HANDLER.runTnt();
    }

    @Override
    public TntHandler getTntHandler() {
        return this.TNT_HANDLER;
    }

    @Override
    public boolean isActive() {
        return this.getBlockState(InPlayerBlockPos.ZERO).m_60734_() != Blocks.f_50016_;
    }

    @Override
    public boolean isFullActive() {
        return this.isActive() && this.TNT_HANDLER.getTnt() == null;
    }

    @Override
    public InPlayerBlockPos minPos() {
        return this.HITBOX_HANDLER.getMinPos();
    }

    @Override
    public InPlayerBlockPos maxPos() {
        return this.HITBOX_HANDLER.getMaxPos();
    }

    @Override
    public int getBiggestProgress() {
        if (this.blocksData != null) {
            int progress = -1;
            for (BlockInPlayer2 block : this.blocksData.values()) {
                int k = MorphedPlayerRenderer.getBrakeProgress(block.getPos());
                if (k <= progress) continue;
                progress = k;
            }
            return progress;
        }
        return -1;
    }

    @Inject(method={"getStandingEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void getStandingEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        if (this.isActive()) {
            cir.setReturnValue((Object)Float.valueOf(this.HITBOX_HANDLER.getEyeHeight()));
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (this.isActive()) {
            cir.setReturnValue((Object)this.HITBOX_HANDLER.calculateDimensions());
        }
    }

    @Override
    public VoxelShape getShape(InPlayerBlockPos offset, @Nullable Vec3 realPos) {
        BlockInPlayer2 block = this.getBlocksData2().get(offset);
        if (block == null) {
            return Shapes.m_83040_();
        }
        VoxelShape shp = block.getBlockState().m_60742_((BlockGetter)this.m_9236_(), block.getPos(), CollisionContext.m_82750_((Entity)this));
        Vec3 rl = realPos != null ? realPos : MorphUtils.getRealBlockPos((PlayerAccessor)this, offset);
        return shp.m_83216_(rl.f_82479_, rl.f_82480_, rl.f_82481_);
    }

    @Override
    public VoxelShape getRenderShape(InPlayerBlockPos pos, Player collisser) {
        BlockInPlayer2 block = this.getBlocksData2().get(pos);
        if (block == null) {
            return Shapes.m_83040_();
        }
        BlockState state = block.getBlockState();
        VoxelShape shape = state.m_60651_((BlockGetter)this.m_9236_(), block.getPos(), CollisionContext.m_82750_((Entity)collisser));
        return shape.m_83216_((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (this.isActive()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getHurtSound(DamageSource damage, CallbackInfoReturnable<SoundEvent> cir) {
        if (this.isActive()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getFallSounds"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getFallSounds(CallbackInfoReturnable<LivingEntity.Fallsounds> cir) {
        if (this.isActive()) {
            cir.setReturnValue((Object)new LivingEntity.Fallsounds(SoundEvents.f_271165_, SoundEvents.f_271165_));
        }
    }

    @Inject(method={"maybeBackOffFromEdge"}, at={@At(value="RETURN")}, cancellable=true)
    public void fixMovement(Vec3 originalVector, MoverType moverType, CallbackInfoReturnable<Vec3> cir) {
        if (this.isActive() && (moverType == MoverType.PLAYER || moverType == MoverType.SELF)) {
            MovementCalculator calculator = new MovementCalculator(this);
            calculator.calculateEnterCorrection(originalVector);
        }
    }

    public PlayerMixin() {
        super(null, null);
    }
}

