/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.blockFix;

import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BucketItem.class})
public class BucketItemMixin {
    @Shadow
    @Final
    private Fluid f_40687_;

    @Inject(locals=LocalCapture.CAPTURE_FAILHARD, method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BucketPickup;pickupBlock(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;")})
    public void prePick(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir, ItemStack itemstack, BlockHitResult hitResult) {
        if (hitResult instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult mHit = (MorphedPlayerHitResult)hitResult;
            mHit.getPlayer().breakingModeStart(true);
        }
    }

    @Inject(locals=LocalCapture.CAPTURE_FAILHARD, method={"use"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/world/level/block/BucketPickup;pickupBlock(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;")})
    public void postPick(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir, ItemStack itemstack, BlockHitResult hitResult) {
        if (hitResult instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult mHit = (MorphedPlayerHitResult)hitResult;
            PlayerAccessor pl = mHit.getPlayer();
            boolean flag = pl.isBreaking();
            pl.breakingModeStart(false);
            if (!level.m_5776_() && flag && pl.getBlocksData2().size() == 1 && pl.getBlockState(InPlayerBlockPos.ZERO) == Blocks.f_50626_.m_49966_()) {
                MorphUtils.destroy(pl, (Entity)player);
            }
        }
    }

    @ModifyVariable(method={"use"}, at=@At(value="STORE"))
    public BlockHitResult placeOut(BlockHitResult hitResult) {
        if (hitResult instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult playerHitResult = (MorphedPlayerHitResult)hitResult;
            if (this.f_40687_ != Fluids.f_76191_) {
                Config.PlaceMode mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class);
                Vec3 vec = playerHitResult.getRealLocation();
                Vec3 tolerance = Vec3.m_82528_((Vec3i)playerHitResult.m_82434_().m_122436_()).m_82490_(-1.0E-7);
                BlockPos pos = BlockPos.m_274446_((Position)vec.m_82549_(tolerance));
                if (mode == Config.PlaceMode.OUT) {
                    return new BlockHitResult(vec, playerHitResult.m_82434_(), pos, playerHitResult.m_82436_());
                }
                if (mode == Config.PlaceMode.DISABLED) {
                    return BlockHitResult.m_82426_((Vec3)vec, (Direction)playerHitResult.m_82434_(), (BlockPos)pos);
                }
            }
        }
        return hitResult;
    }
}

