/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client;

import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Minecraft.class})
public class AttackSupportMixin {
    @Shadow
    @Nullable
    public HitResult f_91077_;
    @Shadow
    public MultiPlayerGameMode f_91072_;
    @Shadow
    public LocalPlayer f_91074_;

    @Inject(locals=LocalCapture.CAPTURE_FAILHARD, method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z")}, cancellable=true)
    public void attack(CallbackInfoReturnable<Boolean> cir, ItemStack itemstack, boolean flag, InputEvent.InteractionKeyMappingTriggered inputEvent) {
        MorphedPlayerHitResult hit;
        HitResult hitResult = this.f_91077_;
        if (hitResult instanceof MorphedPlayerHitResult && (hit = (MorphedPlayerHitResult)hitResult).getPlayer().isFullActive()) {
            Config.HitReaction hitReaction = Config.getInstance().getValue("hitReaction", Config.HitReaction.class);
            boolean needSwing = false;
            if (hitReaction != Config.HitReaction.BRAKING) {
                cir.setReturnValue((Object)true);
                needSwing = true;
            }
            if (hitReaction.hand) {
                this.f_91072_.m_105223_((Player)this.f_91074_, (Entity)hit.getPlayer().player());
            } else if (hitReaction != Config.HitReaction.BRAKING) {
                this.f_91074_.m_36334_();
            }
            if (needSwing && inputEvent.shouldSwingHand()) {
                this.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    @ModifyVariable(method={"continueAttack"}, at=@At(value="HEAD"))
    public boolean check(boolean needContinue) {
        Config.HitReaction hitReaction;
        MorphedPlayerHitResult hit;
        HitResult hitResult;
        if (needContinue && (hitResult = this.f_91077_) instanceof MorphedPlayerHitResult && (hit = (MorphedPlayerHitResult)hitResult).getPlayer().isFullActive() && (hitReaction = Config.getInstance().getValue("hitReaction", Config.HitReaction.class)) != Config.HitReaction.BRAKING) {
            return false;
        }
        return needContinue;
    }
}

