/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.accessors.LevelAcc;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin
implements ClientLevelAccessor {
    @Shadow
    @Final
    private Minecraft f_104565_;
    @Unique
    private final Map<BlockPos, List<BlockInPlayer2>> blocksForTick = new HashMap<BlockPos, List<BlockInPlayer2>>();
    private boolean BErendering;
    private boolean externalGETblockLocked;

    @Shadow
    protected abstract LevelEntityGetter<Entity> m_142646_();

    @Shadow
    protected abstract void m_104689_(BlockPos var1, BlockState var2, ParticleOptions var3, boolean var4);

    @Inject(method={"animateTick"}, at={@At(value="HEAD")})
    public void collectForTick(int x, int y, int z, CallbackInfo ci) {
        int radius = 32;
        this.blocksForTick.clear();
        if (Config.getInstance().getValue("blockClientParticles", Boolean.class).booleanValue()) {
            AABB searchBox = new AABB((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius));
            this.m_142646_().m_142232_(searchBox, entity -> {
                PlayerAccessor pl;
                if (entity instanceof PlayerAccessor && (pl = (PlayerAccessor)entity).isFullActive() && (entity != this.f_104565_.f_91074_ || !this.f_104565_.f_91066_.m_92176_().m_90612_())) {
                    pl.getBlocksData2InArea(searchBox, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(pos, block, realPos) -> {
                        BlockPos realBlockPosInWorld = BlockPos.m_274446_((Position)realPos);
                        this.blocksForTick.computeIfAbsent(realBlockPosInWorld, blockPos -> new ArrayList()).add(block);
                    }));
                }
            });
        }
    }

    @Inject(method={"doAnimateTick"}, at={@At(value="TAIL")})
    public void animatePlayers(int x, int y, int z, int radius, RandomSource random, Block MARKER, BlockPos.MutableBlockPos pos, CallbackInfo ci) {
        List<BlockInPlayer2> list = this.blocksForTick.get(pos);
        if (list != null && !list.isEmpty()) {
            BlockInPlayer2 block = list.size() == 1 ? list.get(0) : list.get(LevelAcc.of((Object)this).f_46441_.m_188503_(list.size()));
            block.animateTick(random, MARKER, blockState -> {
                ParticleOptions particleOptions = block.getBlockState().m_60819_().m_76189_();
                if (particleOptions != null && LevelAcc.of((Object)this).f_46441_.m_188503_(10) == 0) {
                    boolean faceSturdy = block.getBlockState().m_60783_((BlockGetter)LevelAcc.of(this), block.getPos(), Direction.DOWN);
                    this.m_104689_(pos.m_7495_(), (BlockState)blockState, particleOptions, faceSturdy);
                }
            });
        }
    }

    @ModifyVariable(method={"calculateBlockTint"}, at=@At(value="HEAD"))
    public BlockPos getRealPos(BlockPos value) {
        return InPlayerBlockPos.checkOnReal(value);
    }

    @Override
    public boolean specialRenderingMode() {
        return this.BErendering;
    }

    @Override
    public void setSpecialRenderingMode(boolean yes) {
        this.BErendering = yes;
    }

    @Override
    public void lockExternalMorphedBlockGetter(boolean yes) {
        this.externalGETblockLocked = yes;
    }

    @Override
    public boolean isExternalMorphedBlockGetterLocked() {
        return this.externalGETblockLocked;
    }
}

