/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.blockomorph.utils.MorphedPlayerRenderer;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.LevelRendererAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRenderMixin
implements LevelRendererAccessor {
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    @Final
    private EntityRenderDispatcher f_109463_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Unique
    private Vec3 sound;
    @Unique
    private final MorphedPlayerRenderer CUSTOM_RENDERER = new MorphedPlayerRenderer();
    @Unique
    private final ArrayList<AbstractClientPlayer> playersToRender = new ArrayList();

    @Shadow
    protected abstract void m_109588_(PoseStack var1);

    @Invoker(value="renderShape")
    private static void renderShape(PoseStack p_109783_, VertexConsumer p_109784_, VoxelShape p_109785_, double p_109786_, double p_109787_, double p_109788_, float p_109789_, float p_109790_, float p_109791_, float p_109792_) {
    }

    @Override
    public void renderBlockHitbox(PoseStack p_109783_, VertexConsumer p_109784_, VoxelShape p_109785_, double p_109786_, double p_109787_, double p_109788_, float p_109789_, float p_109790_, float p_109791_, float p_109792_) {
        LevelRenderMixin.renderShape(p_109783_, p_109784_, p_109785_, p_109786_, p_109787_, p_109788_, p_109789_, p_109790_, p_109791_, p_109792_);
    }

    @Inject(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")})
    public void redirect(ParticleOptions p_109805_, boolean p_109806_, boolean p_109807_, double x, double y, double z, double p_109811_, double p_109812_, double p_109813_, CallbackInfoReturnable<Particle> cir) {
        this.sound = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.sound.f_82479_;
    }

    @ModifyVariable(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.sound.f_82480_;
    }

    @ModifyVariable(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.sound.f_82481_;
    }

    @Override
    public Long2ObjectMap<SortedSet<BlockDestructionProgress>> getBrakingBlocks() {
        return this.f_109409_;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=2)})
    public void renderMorphedPlayersTranslucent(PoseStack poseStack, float p_109601_, long p_109602_, boolean p_109603_, Camera c, GameRenderer p_109605_, LightTexture p_109606_, Matrix4f p_254120_, CallbackInfo ci) {
        if (this.f_109465_ != null) {
            ProfilerFiller profilerFiller = this.f_109461_.m_91307_();
            profilerFiller.m_6182_("morphedPlayerTranslucentBlocks");
            for (AbstractClientPlayer player : this.playersToRender) {
                this.renderMorphedPlayer(player, c, poseStack);
            }
        }
        this.playersToRender.clear();
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")})
    private void renderPlayer(Entity entity, double p_109519_, double p_109520_, double p_109521_, float p_109522_, PoseStack p_109523_, MultiBufferSource p_109524_, CallbackInfo ci) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            this.playersToRender.add(player);
        }
    }

    private void renderMorphedPlayer(AbstractClientPlayer player, Camera camera, PoseStack posestack) {
        PlayerAccessor pl;
        if (player instanceof PlayerAccessor && (pl = (PlayerAccessor)player).isFullActive()) {
            Vec3 camPos = camera.m_90583_();
            MultiBufferSource.BufferSource buffer = this.f_109464_.m_110104_();
            float tick = Minecraft.m_91087_().m_91296_();
            double d0 = Mth.m_14139_((double)tick, (double)player.f_19790_, (double)player.m_20185_());
            double d1 = Mth.m_14139_((double)tick, (double)player.f_19791_, (double)player.m_20186_());
            double d2 = Mth.m_14139_((double)tick, (double)player.f_19792_, (double)player.m_20189_());
            Vec3 offset = this.f_109463_.m_114382_((Entity)player).m_7860_((Entity)player, tick);
            posestack.m_85836_();
            posestack.m_85837_(d0 - camPos.f_82479_ + offset.f_82479_, d1 - camPos.f_82480_ + offset.f_82480_, d2 - camPos.f_82481_ + offset.f_82481_);
            this.CUSTOM_RENDERER.adjustMatrixForPlayer(posestack, pl, player);
            this.CUSTOM_RENDERER.renderBlock(true, player, posestack, (MultiBufferSource)buffer, pl);
            posestack.m_85849_();
            this.m_109588_(posestack);
        }
    }

    @Inject(method={"setSectionDirty(IIIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectChunkUpdateOnPlayer(int chunkX, int sectionY, int chunkZ, boolean yes, CallbackInfo ci) {
        if (InPlayerBlockPos.isMorphPlayerChunk(new ChunkPos(chunkX, chunkZ))) {
            ci.cancel();
        }
    }
}

