/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic;

import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public abstract class ParticleEngineMixin {
    @Shadow
    protected ClientLevel f_107287_;
    @Shadow
    @Final
    private RandomSource f_107292_;

    @Shadow
    public abstract void m_107344_(Particle var1);

    @Inject(method={"destroy"}, at={@At(value="HEAD")}, cancellable=true)
    public void destroy(BlockPos pos, BlockState state, CallbackInfo ci) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            Vec3 vec = InPlayerBlockPos.checkOnReal(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            this.destroyBlock(pos, state, vec);
            ci.cancel();
        }
    }

    @Inject(method={"crack"}, at={@At(value="HEAD")}, cancellable=true)
    public void crack(BlockPos pos, Direction dir, CallbackInfo ci) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            Vec3 vec = InPlayerBlockPos.checkOnReal(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            this.crackBlock(pos, dir, vec);
            ci.cancel();
        }
    }

    @Unique
    public void crackBlock(BlockPos pos, Direction dir, Vec3 realPos) {
        BlockState blockstate = this.f_107287_.m_8055_(pos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            double i = realPos.f_82479_;
            double j = realPos.f_82480_;
            double k = realPos.f_82481_;
            float f = 0.1f;
            double d = 0.2;
            AABB aabb = blockstate.m_60808_((BlockGetter)this.f_107287_, pos).m_83215_();
            double d0 = i + this.f_107292_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - d) + (double)f + aabb.f_82288_;
            double d1 = j + this.f_107292_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - d) + (double)f + aabb.f_82289_;
            double d2 = k + this.f_107292_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - d) + (double)f + aabb.f_82290_;
            if (dir == Direction.DOWN) {
                d1 = j + aabb.f_82289_ - (double)f;
            } else if (dir == Direction.UP) {
                d1 = j + aabb.f_82292_ + (double)f;
            } else if (dir == Direction.NORTH) {
                d2 = k + aabb.f_82290_ - (double)f;
            } else if (dir == Direction.SOUTH) {
                d2 = k + aabb.f_82293_ + (double)f;
            } else if (dir == Direction.WEST) {
                d0 = i + aabb.f_82288_ - (double)f;
            } else if (dir == Direction.EAST) {
                d0 = i + aabb.f_82291_ + (double)f;
            }
            this.m_107344_(new TerrainParticle(this.f_107287_, d0, d1, d2, 0.0, 0.0, 0.0, blockstate, BlockPos.m_274446_((Position)realPos)).updateSprite(blockstate, pos).m_107268_(0.2f).m_6569_(0.6f));
        }
    }

    public void destroyBlock(BlockPos pos, BlockState state, Vec3 realPos) {
        ParticleEngine manager = (ParticleEngine)this;
        if (!state.m_60795_() && !IClientBlockExtensions.of((BlockState)state).addDestroyEffects(state, (Level)this.f_107287_, pos, manager)) {
            VoxelShape voxelshape = state.m_60808_((BlockGetter)this.f_107287_, pos);
            voxelshape.m_83286_((p_172273_, p_172274_, p_172275_, p_172276_, p_172277_, p_172278_) -> {
                double d1 = Math.min(1.0, p_172276_ - p_172273_);
                double d2 = Math.min(1.0, p_172277_ - p_172274_);
                double d3 = Math.min(1.0, p_172278_ - p_172275_);
                int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_172273_;
                            double d8 = d5 * d2 + p_172274_;
                            double d9 = d6 * d3 + p_172275_;
                            this.m_107344_(new TerrainParticle(this.f_107287_, realPos.f_82479_ + d7, realPos.f_82480_ + d8, realPos.f_82481_ + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, BlockPos.m_274446_((Position)realPos)).updateSprite(state, pos));
                        }
                    }
                }
            });
        }
    }
}

