/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.client.graphic.fluidFog;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.blockomorph.screens.utils.FogLiquidModifier;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.FastColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Shadow
    private static float f_109010_;
    @Shadow
    private static float f_109011_;
    @Shadow
    private static float f_109012_;
    private static final FogLiquidModifier LIQUID_MODIFIER;

    @Inject(method={"setupColor"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V", ordinal=1, remap=false)})
    private static void setCol(Camera camera, float f, ClientLevel clientLevel, int i, float g, CallbackInfo ci) {
        FogLiquidModifier.LiquidFogData fogData = LIQUID_MODIFIER.getFog(GuiUtils.MC.f_91073_.m_104735_(), false);
        if (fogData == null) {
            return;
        }
        int color = fogData.color();
        f_109010_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        f_109011_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        f_109012_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
    }

    @Inject(method={"setupFog"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", remap=false)}, cancellable=true)
    private static void setF(Camera camera, FogRenderer.FogMode fogMode, float f, boolean bl, float g, CallbackInfo ci) {
        FogLiquidModifier.LiquidFogData fogData = LIQUID_MODIFIER.getFog(GuiUtils.MC.f_91073_.m_104735_(), false);
        if (fogData == null) {
            return;
        }
        FogShape shape = FogShape.SPHERE;
        float end = fogData.end();
        if (FastColor.ARGB32.m_13655_((int)FastColor.ARGB32.m_13655_((int)fogData.color())) <= 235) {
            int renderDistance = GuiUtils.MC.f_91066_.m_193772_();
            if (fogData.end() > (float)renderDistance) {
                shape = FogShape.CYLINDER;
                end = renderDistance;
            }
        }
        RenderSystem.setShaderFogStart((float)fogData.start());
        RenderSystem.setShaderFogEnd((float)end);
        RenderSystem.setShaderFogShape((FogShape)shape);
        ci.cancel();
    }

    static {
        LIQUID_MODIFIER = new FogLiquidModifier();
    }
}

