/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.level;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.blockomorph.utils.accessors.LevelAcc;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelInjectsMixin {
    @Unique
    private Vec3 explosion;

    @Inject(method={"isInWorldBoundsHorizontal"}, at={@At(value="HEAD")}, cancellable=true)
    private static void acceptIfPlayerPos(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at=@At(value="HEAD"))
    public BlockState changeState(BlockState original, BlockPos pos) {
        AtomicReference<BlockState> value = new AtomicReference<BlockState>(original);
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            boolean lockLiquid;
            boolean isLiquid = original.m_60734_() instanceof LiquidBlock;
            boolean bl = lockLiquid = isLiquid && pl.isUnContextedBreaking();
            if (pl.isBreaking() && realPos.equals(InPlayerBlockPos.ZERO) && (original == Blocks.f_50016_.m_49966_() || lockLiquid)) {
                value.set(Blocks.f_50626_.m_49966_());
            } else if (lockLiquid) {
                value.set(Blocks.f_50016_.m_49966_());
            }
        }, null, (LevelReader)LevelAcc.of(this));
        return value.get();
    }

    @ModifyVariable(method={"destroyBlock", "removeBlock"}, at=@At(value="STORE"))
    private FluidState changeFluid(FluidState orig, BlockPos pos) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            return Fluids.f_76191_.m_76145_();
        }
        return orig;
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectBreak(BlockPos pos, BlockState blockState, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            if (pl.isOnLoadingBlocks() && blockState == Blocks.f_50016_.m_49966_() && realPos.equals(InPlayerBlockPos.ZERO)) {
                cir.setReturnValue((Object)false);
            }
        }, () -> cir.setReturnValue((Object)false), (LevelReader)LevelAcc.of(this));
    }

    @ModifyVariable(method={"markAndNotifyBlock"}, at=@At(value="STORE"), ordinal=2, remap=false)
    public BlockState getState(BlockState value, BlockPos pos) {
        AtomicReference<BlockState> state = new AtomicReference<BlockState>(value);
        InPlayerBlockPos.check(pos, (pl, realPos) -> state.set(pl.getBlockState((InPlayerBlockPos)realPos)), null, (LevelReader)LevelAcc.of(this));
        return state.get();
    }

    @ModifyVariable(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at=@At(value="HEAD"))
    private Predicate<Entity> eraseOwner(Predicate<Entity> original, Entity ent, AABB aabb) {
        AtomicReference player = new AtomicReference();
        InPlayerBlockPos.check(BlockPos.m_274446_((Position)aabb.m_82399_()), (pl, realPos) -> player.set(pl.player()), null, (LevelReader)LevelAcc.of(this));
        return original.and(entity -> entity != player.get());
    }

    @ModifyVariable(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;Ljava/util/List;I)V"}, at=@At(value="HEAD"))
    private <T extends Entity> Predicate<Entity> eraseOwner(Predicate<Entity> original, EntityTypeTest<Entity, T> type, AABB aabb) {
        AtomicReference player = new AtomicReference();
        InPlayerBlockPos.check(BlockPos.m_274446_((Position)aabb.m_82399_()), (pl, realPos) -> player.set(pl.player()), null, (LevelReader)LevelAcc.of(this));
        return original.and(entity -> entity != player.get());
    }

    @Inject(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;Z)Lnet/minecraft/world/level/Explosion;"}, at={@At(value="HEAD")})
    public void redirect(Entity p_256233_, DamageSource p_255861_, ExplosionDamageCalculator p_255867_, double x, double y, double z, float p_256013_, boolean p_256228_, Level.ExplosionInteraction p_255784_, boolean p_256377_, CallbackInfoReturnable<Explosion> cir) {
        this.explosion = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;Z)Lnet/minecraft/world/level/Explosion;"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.explosion.f_82479_;
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;Z)Lnet/minecraft/world/level/Explosion;"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.explosion.f_82480_;
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;Z)Lnet/minecraft/world/level/Explosion;"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.explosion.f_82481_;
    }
}

