/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.level;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.ClipContextAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.PlayerHitResult;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ClientLevel.class, ServerLevel.class}, priority=1001)
public abstract class LevelOverrideMixin
extends Level {
    protected LevelOverrideMixin(WritableLevelData p_270739_, ResourceKey<Level> p_270683_, RegistryAccess p_270200_, Holder<DimensionType> p_270240_, Supplier<ProfilerFiller> p_270692_, boolean p_270904_, boolean p_270470_, long p_270248_, int p_270466_) {
        super(p_270739_, p_270683_, p_270200_, p_270240_, p_270692_, p_270904_, p_270470_, p_270248_, p_270466_);
    }

    public BlockHitResult m_45547_(ClipContext ctx) {
        ctx = ClipContextAccessor.of(ctx).normalize();
        AtomicReference<BlockHitResult> res = new AtomicReference<BlockHitResult>(super.m_45547_(ctx));
        if (MorphUtils.needModedHit(clazz -> !BlockGetter.class.isAssignableFrom((Class<?>)clazz))) {
            PlayerHitResult.checkHitResult(res.get().m_82450_(), ctx, res::set);
        }
        return res.get();
    }

    public Player m_5788_(double x, double y, double z, double reach, @Nullable Predicate<Entity> predicate) {
        AtomicReference player = new AtomicReference();
        InPlayerBlockPos.check(BlockPos.m_274561_((double)x, (double)y, (double)z), (pl, realPos) -> player.set(pl.player()), null, (LevelReader)this);
        return super.m_5788_(x, y, z, reach, predicate != null ? predicate.and(entity -> entity != player.get()) : null);
    }

    public List<VoxelShape> m_183134_(@Nullable Entity entity, AABB aabb) {
        ArrayList shapes = new ArrayList(super.m_183134_(entity, aabb));
        if (!(aabb.m_82309_() < 1.0E-7 || entity instanceof Projectile && Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile)) {
            this.m_142646_().m_142232_(aabb.m_82400_(2.0), entity1 -> {
                PlayerAccessor pl;
                if (entity1 != entity && EntitySelector.f_20408_.test(entity1) && entity1 instanceof PlayerAccessor && (pl = (PlayerAccessor)entity1).isFullActive()) {
                    this.addCustomShapes(shapes, pl, aabb);
                }
            });
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)shapes.size());
        return builder.addAll(shapes).build();
    }

    @Unique
    private void addCustomShapes(List<VoxelShape> builder, PlayerAccessor pl, AABB aabb) {
        ArrayList blocks = new ArrayList();
        pl.getBlocksData2InArea(aabb.m_82400_(1.0E-7), (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(pos, block, realPos) -> blocks.add(pl.getShape((InPlayerBlockPos)pos, (Vec3)realPos))));
        builder.addAll(blocks);
    }

    public boolean m_45756_(@Nullable Entity entity, AABB aabb) {
        aabb = InPlayerBlockPos.checkOnReal(aabb);
        for (VoxelShape voxelshape : this.m_186434_(entity, aabb)) {
            if (voxelshape.m_83281_()) continue;
            return false;
        }
        for (VoxelShape entityShape : this.m_183134_(entity, aabb)) {
            if (!Shapes.m_83157_((VoxelShape)entityShape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_)) continue;
            return false;
        }
        if (entity == null) {
            return true;
        }
        WorldBorder worldborder = this.m_6857_();
        VoxelShape voxelshape1 = worldborder.m_187566_(entity, aabb) ? worldborder.m_61946_() : null;
        return voxelshape1 == null || !Shapes.m_83157_((VoxelShape)voxelshape1, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
    }
}

