/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.network.ClientBoundBlockPosBoundPacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.blockomorph.utils.dataSyncher.SyncedEntity;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public class ServerEntityMixin {
    @Shadow
    @Final
    private Entity f_8510_;
    @Shadow
    @Final
    private ServerLevel f_8509_;

    @Inject(method={"sendChanges"}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", shift=At.Shift.AFTER, ordinal=0)})
    private void fixAsync(CallbackInfo ci) {
        Entity entity = this.f_8510_;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            pl.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)pl));
        }
    }

    @Inject(method={"addPairing"}, at={@At(value="TAIL")})
    public void start(ServerPlayer looker, CallbackInfo ci) {
        Entity entity = this.f_8510_;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            entity = this.f_8510_;
            if (entity instanceof PlayerAccessor) {
                PlayerAccessor acc = (PlayerAccessor)entity;
                PlayerMorphedSection pos = BlockPosBounds.getChunkPosForPlayer((Player)pl);
                if (pos != null) {
                    MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, (Player)pl, false), looker);
                }
                acc.sendAllContentToPlayer(looker);
            }
        }
        SyncedEntity.of(this.f_8510_).checkOrSendImmediate(this::sendCustomPacket, true);
    }

    @Inject(method={"sendChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getPassengers()Ljava/util/List;")})
    public void sync(CallbackInfo ci) {
        SyncedEntity.of(this.f_8510_).checkOrSendImmediate(this::sendCustomPacket, false);
    }

    private void sendCustomPacket(BlockMorphPacket packet) {
        this.f_8509_.m_7726_().f_8325_.m_183262_(this.f_8510_.m_146902_(), false).forEach(player -> MorphUtils.sendPlayer(packet, player));
    }

    @Inject(method={"removePairing"}, at={@At(value="TAIL")})
    public void stop(ServerPlayer looker, CallbackInfo ci) {
        ServerPlayer pl;
        PlayerMorphedSection pos;
        Entity entity = this.f_8510_;
        if (entity instanceof ServerPlayer && (pos = BlockPosBounds.getChunkPosForPlayer((Player)(pl = (ServerPlayer)entity))) != null) {
            MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, (Player)pl, true), looker);
        }
    }
}

