/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import net.blockomorph.utils.accessors.LevelAcc;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Unique
    private Vec3 sound;
    @Unique
    private Vec3 explosion;

    @Inject(method={"blockEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockEvent(BlockPos pos, Block block, int a, int b, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ci.cancel();
            pl.prepareSync((InPlayerBlockPos)realPos, new BlockEventData(pos, block, a, b));
        }, () -> ((CallbackInfo)ci).cancel(), (LevelReader)LevelAcc.ofSv(this));
    }

    @Inject(method={"destroyBlockProgress"}, at={@At(value="HEAD")}, cancellable=true)
    public void sendCracks(int playerId, BlockPos pos, int progress, CallbackInfo ci) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            ci.cancel();
            ServerChunkCache cache = LevelAcc.ofSv(this).m_7726_();
            Entity pl = LevelAcc.ofSv(this).m_6815_(playerId);
            if (pl instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pl;
                cache.m_8445_((Entity)player, (Packet)new ClientboundBlockDestructionPacket(playerId, pos, progress));
            }
        }
    }

    @Inject(method={"playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V"}, at={@At(value="HEAD")})
    public void redirect(Player p_263330_, double x, double y, double z, Holder<SoundEvent> p_263412_, SoundSource p_263338_, float p_263352_, float p_263390_, long p_263403_, CallbackInfo ci) {
        this.sound = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.sound.f_82479_;
    }

    @ModifyVariable(method={"playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.sound.f_82480_;
    }

    @ModifyVariable(method={"playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.sound.f_82481_;
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")})
    public void redirect(Entity p_256039_, DamageSource p_255778_, ExplosionDamageCalculator p_256002_, double x, double y, double z, float p_256045_, boolean p_255686_, Level.ExplosionInteraction p_255827_, CallbackInfoReturnable<Explosion> cir) {
        this.explosion = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"explode"}, at=@At(value="HEAD"), ordinal=0)
    public double getXp(double value) {
        return this.explosion.f_82479_;
    }

    @ModifyVariable(method={"explode"}, at=@At(value="HEAD"), ordinal=1)
    public double getYp(double value) {
        return this.explosion.f_82480_;
    }

    @ModifyVariable(method={"explode"}, at=@At(value="HEAD"), ordinal=2)
    public double getZp(double value) {
        return this.explosion.f_82481_;
    }
}

