/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import java.util.List;
import java.util.Set;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerPacketListenerMixin {
    @Shadow
    public ServerPlayer f_9743_;
    @Unique
    private Vec3 tpPos;

    @Inject(method={"noBlocksAround"}, at={@At(value="RETURN")}, cancellable=true)
    public void test(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            AABB roundAABB = entity.m_20191_().m_82400_(0.0625).m_82363_(0.0, -0.55, 0.0);
            List entities = this.f_9743_.m_9236_().m_45933_(entity, roundAABB);
            for (Entity ent : entities) {
                PlayerAccessor pl;
                if (!((Boolean)cir.getReturnValue()).booleanValue()) {
                    return;
                }
                if (!(ent instanceof PlayerAccessor) || !(pl = (PlayerAccessor)ent).isFullActive()) continue;
                pl.getBlocksData2InArea(roundAABB, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(realPos, block, vec3) -> cir.setReturnValue((Object)false)));
            }
        }
    }

    @Inject(method={"isPlayerCollidingWithAnythingNew"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkCollision(LevelReader levelReader, AABB playerBox, double moveX, double moveY, double moveZ, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player = ((ServerGamePacketListenerImpl)this).f_9743_;
        AABB movedBox = player.m_20191_().m_82386_(moveX - player.m_20185_(), moveY - player.m_20186_(), moveZ - player.m_20189_());
        Iterable collisions = levelReader.m_186431_((Entity)player, movedBox.m_82406_((double)1.0E-5f));
        boolean isAlreadyInsideShape = false;
        boolean isTryingToEnterShape = false;
        for (VoxelShape collisionShape : collisions) {
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)playerBox.m_82406_((double)1.0E-5f)), (VoxelShape)collisionShape, (BooleanOp)BooleanOp.f_82689_)) {
                isAlreadyInsideShape = true;
            }
            if (!Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)movedBox.m_82406_((double)1.0E-5f)), (VoxelShape)collisionShape, (BooleanOp)BooleanOp.f_82689_)) continue;
            isTryingToEnterShape = true;
        }
        if (isTryingToEnterShape && !isAlreadyInsideShape) {
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleUseItemOn"}, at={@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V")}, cancellable=true)
    private void redirectUpdate(ServerboundUseItemOnPacket packet, CallbackInfo ci) {
        BlockHitResult res = packet.m_134706_();
        BlockPos pos = res.m_82425_().m_121945_(res.m_82434_());
        InPlayerBlockPos.check(pos, (pl, realPos) -> {
            ci.cancel();
            this.f_9743_.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(pos, pl.getBlockState((InPlayerBlockPos)realPos)));
        }, null, (LevelReader)this.f_9743_.m_284548_());
    }

    @Inject(method={"handleUseItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isItemEnabled(Lnet/minecraft/world/flag/FeatureFlagSet;)Z")}, cancellable=true)
    public void checkAccess(ServerboundUseItemOnPacket pkt, CallbackInfo ci) {
        BlockHitResult hit = pkt.m_134706_();
        InPlayerBlockPos.check(hit.m_82425_(), (pl, realPos) -> {
            if (!pl.isActive()) {
                ci.cancel();
            }
        }, null, (LevelReader)this.f_9743_.m_9236_());
        if (!ci.isCancelled() && MorphUtils.needRejectUse(this.f_9743_.m_9236_(), hit)) {
            ci.cancel();
        }
    }

    @Inject(method={"handleInteract"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    public void checkAccess(ServerboundInteractPacket pkt, CallbackInfo ci) {
        PlayerAccessor pl;
        Entity entity = pkt.m_179603_(this.f_9743_.m_284548_());
        if (entity instanceof PlayerAccessor && (pl = (PlayerAccessor)entity).isActive() && !Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerAction"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    public void checkAccess(ServerboundPlayerActionPacket pkt, CallbackInfo ci) {
        switch (pkt.m_134285_()) {
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                InPlayerBlockPos.check(pkt.m_134281_(), (pl, realPos) -> {
                    if (!pl.isFullActive() || Config.getInstance().getValue("hitReaction", Config.HitReaction.class) != Config.HitReaction.BRAKING) {
                        ci.cancel();
                    }
                }, null, (LevelReader)this.f_9743_.m_9236_());
            }
        }
    }

    @Inject(method={"teleport(DDDFFLjava/util/Set;)V"}, at={@At(value="HEAD")})
    public void redirect(double x, double y, double z, float yaw, float xRot, Set<RelativeMovement> p_9786_, CallbackInfo ci) {
        this.tpPos = InPlayerBlockPos.checkOnReal(new Vec3(x, y, z));
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.tpPos.f_82479_;
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.tpPos.f_82480_;
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.tpPos.f_82481_;
    }
}

