/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import com.mojang.authlib.GameProfile;
import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    private boolean f_8937_;

    @Shadow
    public abstract boolean m_7998_(Entity var1, boolean var2);

    @Shadow
    public abstract void m_8127_();

    public ServerPlayerMixin(Level p_250508_, BlockPos p_250289_, float p_251702_, GameProfile p_252153_) {
        super(p_250508_, p_250289_, p_251702_, p_252153_);
    }

    @ModifyVariable(method={"setRespawnPosition(Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/BlockPos;FZZ)V"}, at=@At(value="HEAD"))
    private BlockPos modifyBlockPos(BlockPos originalPos) {
        AtomicReference<BlockPos> newPos = new AtomicReference<BlockPos>(originalPos);
        InPlayerBlockPos.check(originalPos, (pl, realPos) -> newPos.set(BlockPos.m_274446_((Position)MorphUtils.getRealBlockPos(pl, realPos))), () -> newPos.set(null), (LevelReader)this.m_9236_());
        return newPos.get();
    }

    @Inject(method={"setRespawnPosition"}, at={@At(value="TAIL")})
    public void force(ResourceKey<Level> p_9159_, BlockPos pos, float p_9161_, boolean p_9162_, boolean p_9163_, CallbackInfo ci) {
        if (pos != null && InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            this.f_8937_ = true;
        }
    }

    @Inject(method={"startSleeping"}, at={@At(value="TAIL")})
    public void bound(BlockPos pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> this.m_7998_((Entity)pl.player(), true), null, (LevelReader)this.m_9236_());
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="HEAD")})
    public void unbound(boolean p_9165_, boolean p_9166_, CallbackInfo ci) {
        this.m_21257_().ifPresent(blockpos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(blockpos.m_123341_())) {
                this.m_8127_();
            }
        });
    }

    @Inject(method={"isReachableBedBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void realInRange(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.m_123341_())) {
            Vec3 real = InPlayerBlockPos.checkOnReal(Vec3.m_82539_((Vec3i)pos));
            cir.setReturnValue((Object)(Math.abs(this.m_20185_() - real.m_7096_()) <= 3.0 && Math.abs(this.m_20186_() - real.m_7098_()) <= 2.0 && Math.abs(this.m_20189_() - real.m_7094_()) <= 3.0 ? 1 : 0));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void dead(DamageSource damageSource, CallbackInfo ci) {
        if (PlayerAccessor.of(this).isFullActive() && !damageSource.m_276093_(MorphUtils.PLAYER_DESTROYED) && !damageSource.m_276093_(MorphUtils.PLAYER_DESTROYED_NULL)) {
            PlayerAccessor.of(this).getBlocksData2().values().forEach(block -> this.m_9236_().m_46796_(2001, block.getPos(), Block.m_49956_((BlockState)block.getBlockState())));
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
    public void restoreBlockMorphData(ServerPlayer old, boolean fromEnd, CallbackInfo ci) {
        PlayerAccessor pl = PlayerAccessor.of(this);
        PlayerAccessor oldPl = PlayerAccessor.of((Player)old);
        if (!fromEnd && Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue()) {
            pl.applyBlockMorph(Blocks.f_50016_.m_49966_(), null, BannedBlock.Source.SYSTEM);
            for (InPlayerBlockPos pos : oldPl.getUpdates()) {
                pl.prepareSync(pos);
            }
        } else {
            pl.loadBlockData(oldPl.saveBlockData(false), null, true);
        }
    }
}

