/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ClientBoundApplyBlockMorphPacket
implements BlockMorphPacket {
    public static final String ID = "client_bound_apply_block_morph_packet";
    BlockState state;
    int id;

    public ClientBoundApplyBlockMorphPacket(BlockState state, PlayerAccessor player) {
        this.state = state;
        this.id = player.player().m_19879_();
    }

    public ClientBoundApplyBlockMorphPacket(FriendlyByteBuf buf) {
        this.state = (BlockState)buf.m_236816_((IdMap)Block.f_49791_);
        this.id = buf.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_236818_((IdMap)Block.f_49791_, (Object)this.state);
        buffer.writeInt(this.id);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(Player player) {
        Entity ent = Minecraft.m_91087_().f_91073_.m_6815_(this.id);
        if (ent instanceof PlayerAccessor) {
            PlayerAccessor pl = (PlayerAccessor)ent;
            pl.setOnLoadingBlocks(true);
            for (InPlayerBlockPos pos : pl.getBlocksData2().keySet()) {
                if (pos.equals(InPlayerBlockPos.ZERO)) continue;
                pl.setBlockState(pos, Blocks.f_50016_.m_49966_(), false);
            }
            pl.setBlockState(InPlayerBlockPos.ZERO, this.state, false);
            BlockPos pos = InPlayerBlockPos.ZERO.boundedBlockPos(pl.player());
            if (pos != null) {
                this.state.m_60734_().m_6402_(pl.player().m_9236_(), pos, this.state, (LivingEntity)pl.player(), new ItemStack((ItemLike)this.state.m_60734_().m_5456_(), 1));
            }
            pl.setOnLoadingBlocks(false);
        }
    }
}

