/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.screens.morphConfig.nbtEditor.PlayerBlockEntityNbtEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class ClientBoundServerBlockEntityTagPacket
implements BlockMorphPacket {
    public static final String ID = "client_bound_server_block_entity_packet";
    CompoundTag tagForGui;
    boolean message;

    private ClientBoundServerBlockEntityTagPacket(CompoundTag tagForGui, boolean message) {
        this.tagForGui = tagForGui;
        this.message = message;
    }

    public ClientBoundServerBlockEntityTagPacket(FriendlyByteBuf buffer) {
        this.tagForGui = buffer.m_130260_();
        this.message = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.tagForGui);
        buffer.writeBoolean(this.message);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof PlayerBlockEntityNbtEditor) {
            PlayerBlockEntityNbtEditor nbtEditor = (PlayerBlockEntityNbtEditor)screen;
            if (this.message) {
                if (this.tagForGui != null) {
                    boolean exc = this.tagForGui.m_128471_("exc");
                    MutableComponent text = Component.m_237115_((String)(exc ? "blockomorph.gui.nbtEditor.parseError.exception" : "blockomorph.gui.nbtEditor.parseError.save"));
                    String error = text.getString() + this.tagForGui.m_128461_("err");
                    nbtEditor.setError(error);
                }
            } else {
                nbtEditor.setNewTag(this.tagForGui);
            }
        }
    }

    public static ClientBoundServerBlockEntityTagPacket createForTag(CompoundTag tag) {
        return new ClientBoundServerBlockEntityTagPacket(tag, false);
    }

    public static ClientBoundServerBlockEntityTagPacket createForError(String error, boolean isException) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("err", error);
        tag.m_128379_("exc", isException);
        return new ClientBoundServerBlockEntityTagPacket(tag, true);
    }
}

