/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import java.util.function.Supplier;
import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MainPacket {
    ResourceLocation id;
    BlockMorphPacket packet;

    public MainPacket(BlockMorphPacket packet) {
        this.id = new ResourceLocation("blockomorph", packet.getId());
        this.packet = packet;
    }

    public MainPacket(FriendlyByteBuf buf) {
        this.id = buf.m_130281_();
        MorphUtils.PacketInfo suppl = MorphUtils.getHandler(this.id);
        if (suppl.packet() != null) {
            this.packet = suppl.packet().apply(buf);
        }
    }

    public static void write(MainPacket message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.id);
        message.packet.write(buffer);
    }

    public static void handler(MainPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            MorphUtils.PacketInfo suppl = MorphUtils.getHandler(message.id);
            if (message.packet == null || suppl == null) {
                throw new IllegalArgumentException("Unknown packet type received!");
            }
            boolean cl = suppl.isClient();
            NetworkDirection dir = context.getDirection();
            if (dir == NetworkDirection.PLAY_TO_CLIENT && !cl || dir == NetworkDirection.PLAY_TO_SERVER && cl) {
                throw new IllegalArgumentException("Wrong side for packet!");
            }
            message.packet.handle((Player)context.getSender());
        }).exceptionally(e -> {
            context.getNetworkManager().m_129507_((Component)Component.m_237113_((String)("Broken BlockMorphPacket with ID " + message.id + ": " + e.getMessage())));
            MorphUtils.LOGGER.error("Error while handle packet from player - " + context.getSender() + ":", e);
            return null;
        });
        context.setPacketHandled(true);
    }

    public String toString() {
        return "BlockMorphMainPacket: " + this.id;
    }
}

