/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ServerBoundBlockMorphPacket
implements BlockMorphPacket {
    public static final String ID = "server_bound_block_morph_packet";
    CompoundTag tag;

    private ServerBoundBlockMorphPacket(CompoundTag nbt) {
        this.tag = nbt;
    }

    public ServerBoundBlockMorphPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(Player player) {
        if (player instanceof PlayerAccessor) {
            PlayerAccessor mob = (PlayerAccessor)player;
            if (this.tag == null) {
                throw new IllegalArgumentException("Payload is null!");
            }
            if (this.tag.m_128441_("fuse")) {
                mob.setTnt();
                return;
            }
            BlockState blockstate = NbtUtils.m_247651_((HolderGetter)player.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)this.tag.m_128469_("BlockState"));
            CompoundTag nbt = this.tag.m_128425_("Tags", 10) ? this.tag.m_128469_("Tags") : null;
            this.doMorph(mob, blockstate, nbt);
        }
    }

    private void doMorph(PlayerAccessor player, BlockState state, CompoundTag nbt) {
        Config.ScreenAccess access = MorphUtils.getScreenAccess(player.player());
        if (!access.morph && !player.getBlockState(InPlayerBlockPos.ZERO).m_60713_(state.m_60734_())) {
            throw new IllegalArgumentException("You not have access to change your blockstate.");
        }
        if (!(access.config || nbt == null && state.m_60734_().m_49966_().equals(state))) {
            throw new IllegalArgumentException("You not have access to config your block.");
        }
        BannedBlock reason = player.applyBlockMorph(state, nbt, BannedBlock.Source.NETWORK);
        if (reason != null && reason != BannedBlock.ALREADY_MORPHED) {
            throw new IllegalArgumentException(reason.reason());
        }
    }

    public static ServerBoundBlockMorphPacket create(BlockState state, @Nullable CompoundTag tagMorph) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)state));
        if (tagMorph != null) {
            tag.m_128365_("Tags", (Tag)tagMorph);
        }
        return new ServerBoundBlockMorphPacket(tag);
    }

    public static ServerBoundBlockMorphPacket fuse() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("fuse", true);
        return new ServerBoundBlockMorphPacket(tag);
    }
}

