/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlocksManager {
    protected static final ResourceKey<CreativeModeTab> ALLOWED_TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)GuiUtils.res("allowed_blocks"));
    protected static final HashMap<ResourceKey<CreativeModeTab>, List<SavedBlock>> ALL_TAB_CONTENTS = new HashMap();
    protected final List<SavedBlock> renderableBlocks = new ArrayList<SavedBlock>(16){

        @Override
        public SavedBlock get(int index) {
            if (index >= this.size() || index < 0) {
                return null;
            }
            return (SavedBlock)super.get(index);
        }
    };
    protected static List<Block> ALL_BLOCKS;
    private static FeatureFlagSet FEATURE_FLAGS;
    private static HolderLookup.Provider HOLDER;
    public final ScrollerManager<SavedBlock> scrollerManager;
    private final AbstractMorphScreen parentScreen;

    public BlocksManager(AbstractMorphScreen screen) {
        this.parentScreen = screen;
        this.scrollerManager = new ScrollerManager<SavedBlock>(() -> screen.getLeftPos() + 158, () -> screen.getTopPos() + 16, 142, 4, 4, this.renderableBlocks, null);
    }

    public void render(GuiUtils gui, AbstractMorphScreen.OnRenderingFrame onRendering) {
        int size = 36;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                BlockEntity blockEntity;
                SavedBlock block = this.renderableBlocks.get(y * 4 + x);
                if (block == null) continue;
                Block block2 = block.getState().m_60734_();
                if (block2 instanceof EntityBlock) {
                    EntityBlock ent = (EntityBlock)block2;
                    v0 = ent.m_142194_(GuiUtils.AIR, block.getState());
                } else {
                    v0 = blockEntity = null;
                }
                if (blockEntity != null) {
                    blockEntity.m_142339_((Level)GuiUtils.MC.f_91073_);
                    if (block.getTag() != null) {
                        try {
                            blockEntity.m_142466_(block.getTag());
                        }
                        catch (Exception ent) {
                            // empty catch block
                        }
                    }
                }
                gui.renderBlockInGui(block.getState(), blockEntity, this.parentScreen.getLeftPos() + 42 + x * size, this.parentScreen.getTopPos() + 42 + y * size, 20.0f);
                gui.renderAdditionalOnBlock(block.getState(), this.parentScreen.getLeftPos() + 20 + x * size, this.parentScreen.getTopPos() + 25 + y * size, 30.0f);
                int blockX = x;
                int blockY = y;
                gui.renderInDepthIfNeededAfterBlockRendering(() -> onRendering.render(block, this.parentScreen.getLeftPos() + 10 + blockX * size, this.parentScreen.getTopPos() + 15 + blockY * size));
            }
        }
        this.scrollerManager.renderScroller(gui);
    }

    @Nullable
    public SavedBlock getBlockAtPosition(double x, double y) {
        return this.renderableBlocks.get(this.findBlockIndex(x, y));
    }

    public int findBlockIndex(double mouseX, double mouseY) {
        int size = 36;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int blockY;
                int blockX = this.parentScreen.getLeftPos() + 10 + x * size;
                if (!GuiUtils.isMouseOver(blockX, blockY = this.parentScreen.getTopPos() + 15 + y * size, blockX + size - 1, blockY + size, mouseX, mouseY)) continue;
                return y * 4 + x;
            }
        }
        return -1;
    }

    public List<CreativeModeTab> sortTabsIfItemsIsBlocks() {
        LocalPlayer player = (LocalPlayer)this.parentScreen.getPlayer();
        FeatureFlagSet set = player.f_108617_.m_247016_();
        RegistryAccess holder = player.m_9236_().m_9598_();
        if (!set.equals((Object)FEATURE_FLAGS) || HOLDER != holder) {
            ALL_TAB_CONTENTS.clear();
            ALL_BLOCKS = BuiltInRegistries.f_256975_.m_123024_().filter(block -> block.m_245993_(set)).toList();
            this.putContentTabs(set);
            this.putSearchTab();
            this.putUnsortableTab();
        }
        this.putSavedTab();
        this.putAllowedTab();
        FEATURE_FLAGS = set;
        HOLDER = holder;
        return BuiltInRegistries.f_279662_.m_123024_().map(tab -> {
            List<SavedBlock> list;
            ResourceKey<CreativeModeTab> key = TabManager.getKeyFromTab(tab);
            if (tab.m_257962_() == CreativeModeTab.Type.CATEGORY && key != CreativeModeTabs.f_256837_ && (list = ALL_TAB_CONTENTS.get(key)) != null && !list.isEmpty()) {
                return tab;
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public void searchBlocks(String searchName) {
        TabManager tabs = this.parentScreen.TAB_MANAGER;
        if (tabs.hasSearchBar()) {
            if (searchName.isEmpty()) {
                tabs.selectTab(TabManager.selectedTab);
            } else {
                List<SavedBlock> list = ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(TabManager.selectedTab));
                if (list != null) {
                    this.scrollerManager.setScrollOffset(0.0f);
                    List<SavedBlock> blocks = list.stream().filter(block -> {
                        String name = block.getName() != null ? block.getName() : block.getState().m_60734_().m_49954_().getString();
                        return name.toLowerCase().contains(searchName.toLowerCase());
                    }).toList();
                    this.scrollerManager.setMainList(blocks);
                    this.scrollerManager.refreshList();
                }
            }
        }
    }

    public boolean mouseClicked(double x, double y, AbstractMorphScreen.OnBlockClick click) {
        SavedBlock block = this.parentScreen.BLOCKS_MANAGER.getBlockAtPosition(x, y);
        if (block != null) {
            SoundInstance sound = click.click(block, this.parentScreen.BLOCKS_MANAGER.findBlockIndex(x, y), TabManager.getSelectedTab(), TabManager.getTabPage());
            if (sound != null) {
                GuiUtils.MC.m_91106_().m_120367_(sound);
            }
            return true;
        }
        return this.scrollerManager.mouseClicked(x, y);
    }

    protected void putContentTabs(FeatureFlagSet set) {
        BuiltInRegistries.f_279662_.m_6579_().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            CreativeModeTab tab = (CreativeModeTab)entry.getValue();
            if (tab.m_257962_() == CreativeModeTab.Type.CATEGORY) {
                List<SavedBlock> blocks = tab.m_260957_().stream().map(item -> {
                    BlockItem block;
                    Item patt6926$temp = item.m_41720_();
                    if (patt6926$temp instanceof BlockItem && (block = (BlockItem)patt6926$temp).m_245993_(set)) {
                        return new SavedBlock(this.prepareBlockStateTag(block.m_40614_().m_49966_(), (ItemStack)item), this.getTagForBlockEntity((ItemStack)item), null);
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
                ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)key, blocks);
            }
        });
    }

    @Nullable
    private CompoundTag getTagForBlockEntity(ItemStack stack) {
        return BlockItem.m_186336_((ItemStack)stack);
    }

    private BlockState prepareBlockStateTag(BlockState blockState, ItemStack item) {
        if (item.m_41783_() != null) {
            CompoundTag properties = item.m_41783_().m_128469_("BlockStateTag");
            CompoundTag blockstate = NbtUtils.m_129202_((BlockState)blockState);
            blockstate.m_128365_("Properties", (Tag)properties);
            return NbtUtils.m_247651_((HolderGetter)GuiUtils.MC.f_91073_.m_9598_().m_255025_(Registries.f_256747_), (CompoundTag)blockstate);
        }
        return blockState;
    }

    protected void putSearchTab() {
        ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256750_, ALL_BLOCKS.stream().map(block -> new SavedBlock(block.m_49966_(), null, null)).toList());
    }

    protected void putUnsortableTab() {
        ArrayList newList = new ArrayList();
        ALL_BLOCKS.forEach(block -> {
            boolean contains = false;
            block0: for (Map.Entry<ResourceKey<CreativeModeTab>, List<SavedBlock>> entry : ALL_TAB_CONTENTS.entrySet()) {
                if (entry.getKey() == CreativeModeTabs.f_256750_) continue;
                List<SavedBlock> list = entry.getValue();
                for (SavedBlock block2 : list) {
                    if (block2.getState() == null || block2.getState().m_60734_() != block) continue;
                    contains = true;
                    continue block0;
                }
            }
            if (!contains && !newList.contains(block)) {
                newList.add(block);
            }
        });
        List<SavedBlock> old = ALL_TAB_CONTENTS.get(CreativeModeTabs.f_256837_);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (old != null) {
            builder.addAll(old);
        }
        builder.addAll(newList.stream().map(block -> new SavedBlock(block.m_49966_(), null, null)).toList());
        ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256837_, (List<SavedBlock>)builder.build());
    }

    protected void putSavedTab() {
        ALL_TAB_CONTENTS.put((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256917_, AbstractMorphScreen.SAVED_BLOCK_MANAGER.get().values().stream().toList());
    }

    protected void putAllowedTab() {
        ALL_TAB_CONTENTS.put(ALLOWED_TAB_KEY, ALL_BLOCKS.stream().map(block -> {
            BannedBlock reason = BannedBlock.isBannedBlock(block.m_49966_(), this.parentScreen.getPlayer(), BannedBlock.Source.SYSTEM);
            if (reason == null || reason.systemLock()) {
                return new SavedBlock(block.m_49966_(), null, null);
            }
            return null;
        }).filter(Objects::nonNull).toList());
    }

    protected void updateAllowedBlocks() {
        this.putAllowedTab();
        TabManager tabs = this.parentScreen.TAB_MANAGER;
        tabs.putAllowedTabIfNeed();
        if (TabManager.selectedTab == TabManager.ALLOWED_TAB) {
            if (tabs.SPECIAL_TABS.contains(TabManager.ALLOWED_TAB)) {
                tabs.selectTab(TabManager.ALLOWED_TAB);
            } else {
                tabs.selectTab(CreativeModeTabs.m_257543_());
            }
        }
    }
}

