/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import java.util.List;
import java.util.function.Consumer;
import net.blockomorph.network.ServerBoundBlockMorphPacket;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.SpriteImageButton;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MorphScreen
extends AbstractMorphScreen {
    private static final ResourceLocation UNMORPH_BUTTON_SPRITE = GuiUtils.res("textures/screens/unmorph_but.png");
    private static final ResourceLocation FUSE_BUTTON_SPRITE = GuiUtils.res("textures/screens/flame_but.png");
    private static final ResourceLocation LOCK_FRAME = GuiUtils.res("textures/screens/sel_lock.png");
    private static final ResourceLocation SELECTED_FRAME = GuiUtils.res("textures/screens/selected.png");
    private SpriteImageButton fuseButton;

    public MorphScreen(boolean useAllowTab, boolean useSavedTab) {
        super(new AbstractMorphScreen.MorphScreenOptions(useAllowTab, useSavedTab, false));
    }

    @Override
    protected void initAdditional(Consumer<AbstractWidget> action) {
        action.accept((AbstractWidget)new SpriteImageButton(this.leftPos + 10, this.topPos + this.imageHeight + 1, 26, 26, UNMORPH_BUTTON_SPRITE, button -> MorphUtils.sendServer(ServerBoundBlockMorphPacket.create(Blocks.f_50016_.m_49966_(), null)), () -> this.player.isFullActive(), true));
        this.fuseButton = new SpriteImageButton(this.leftPos - 28, this.topPos + this.imageHeight + 1, 26, 26, FUSE_BUTTON_SPRITE, button -> MorphUtils.sendServer(ServerBoundBlockMorphPacket.fuse()), () -> this.player.getTnt() == null, true);
        action.accept((AbstractWidget)this.fuseButton);
        this.fuseButtonVisibilityCheck();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.checkSavedTab();
        this.setUseUpperTabs(MorphUtils.getScreenAccess((Player)this.player.player()).config);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, tick);
        this.fuseButtonVisibilityCheck();
    }

    private void fuseButtonVisibilityCheck() {
        this.fuseButton.f_93624_ = this.player.getBlockState(InPlayerBlockPos.ZERO).m_60734_() instanceof TntBlock;
    }

    @Nullable
    private BannedBlock isBannedBlock(SavedBlock block) {
        if (!(MorphUtils.getScreenAccess((Player)this.player.player()).config || block.getTag() == null && block.getState().m_60734_().m_49966_().equals(block.getState()))) {
            return new BannedBlock("You cannot morph into configured block!", (Component)Component.m_237115_((String)"blockomorph.bannedBlock.configured"));
        }
        return BannedBlock.isBannedBlock(block.getState(), this.player, BannedBlock.Source.NETWORK);
    }

    @Override
    public void onOperatorRightsChanged() {
        this.onConfigSynced();
    }

    @Override
    public void onConfigSynced() {
        super.onConfigSynced();
        this.checkSavedTab();
        this.setUseUpperTabs(MorphUtils.getScreenAccess((Player)this.player.player()).config);
    }

    private void checkSavedTab() {
        if (this.options.useSavedBlocksTab()) {
            CreativeModeTab savedBlocks = TabManager.getTabFromKey((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256917_);
            if (!MorphUtils.getScreenAccess((Player)this.player.player()).config) {
                this.TAB_MANAGER.SPECIAL_TABS.remove(savedBlocks);
                if (TabManager.getSelectedTab() == savedBlocks) {
                    this.TAB_MANAGER.selectTab(CreativeModeTabs.m_257543_());
                }
            } else if (!this.TAB_MANAGER.SPECIAL_TABS.contains(savedBlocks)) {
                this.TAB_MANAGER.SPECIAL_TABS.add(2, savedBlocks);
            }
        }
    }

    @Override
    protected SoundInstance onClickOnBlock(SavedBlock block, int number, CreativeModeTab selectedTab, int page) {
        if (this.isBannedBlock(block) == null) {
            MorphUtils.sendServer(ServerBoundBlockMorphPacket.create(block.getState(), block.getTag()));
            return GuiUtils.getClickSound();
        }
        return null;
    }

    @Override
    protected void renderFrame(SavedBlock block, int x, int y) {
        BlockState state = block.getState();
        BannedBlock ban = this.isBannedBlock(block);
        if (ban != null) {
            this.gui.blitMonoImage(LOCK_FRAME, x, y, 36, 36);
            return;
        }
        BlockState playerState = this.player.getBlockState(InPlayerBlockPos.ZERO);
        CompoundTag tg = this.player.getTag(InPlayerBlockPos.ZERO);
        if (state.equals(playerState) && (block.getTag() == null || tg.equals((Object)block.getTag()))) {
            this.gui.blitMonoImage(SELECTED_FRAME, x, y, 36, 36);
        }
    }

    @Override
    protected void renderTooltip() {
        SavedBlock block = this.BLOCKS_MANAGER.getBlockAtPosition(this.gui.getMouseX(), this.gui.getMouseY());
        if (block != null) {
            BannedBlock ban = this.isBannedBlock(block);
            if (ban != null) {
                MutableComponent name = block.getName() == null ? block.getState().m_60734_().m_49954_() : Component.m_237113_((String)block.getName());
                List<MutableComponent> hints = List.of(name, Component.m_237113_((String)(ChatFormatting.RED + ban.text().getString())));
                this.gui.renderTooltip(hints, this.gui.getMouseX(), this.gui.getMouseY());
            } else {
                super.renderTooltip();
            }
        }
    }
}

