/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.blockomorph.screens.AbstractScreen;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtPath;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.AbstractInterpritationTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ListenerEditBox;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.screens.utils.SpriteImageButton;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public abstract class NbtEditorScreen
extends AbstractScreen {
    private static final ScrollerManager.CustomBarData SCOLLER = new ScrollerManager.CustomBarData(GuiUtils.res("textures/screens/nbt_scroller.png"), 7, 15);
    public static final ResourceLocation BUTTONS_SPRITE = GuiUtils.res("textures/screens/nbt_buttons.png");
    public static final ResourceLocation LOCK_IMAGE = GuiUtils.res("textures/screens/nbt_lock.png");
    public static final int BUTTON_SPRITE_LENGTH = 46;
    public static final int BUTTON_SPRITE_HEIGHT = 43;
    private static final int MAX_PLATES_COUNT = 7;
    private boolean initialized;
    private final BiConsumer<String, Boolean> onEntering = (tagName, intr) -> this.enterInTag(this.path.append((String)tagName), (boolean)intr);
    private CompoundTag editingTag;
    private final Runnable onTagEdited;
    private EditBox tagBox;
    private Button pathExit;
    private Button addButton;
    private Button restoreButton;
    private int internalBoxX;
    private int internalBoxY;
    protected final int internalBoxLength = 173;
    protected final int internalBoxHeigth = 159;
    private final List<RenderableTag<?>> renderables = new ArrayList<RenderableTag<?>>(7){

        @Override
        public boolean add(RenderableTag<?> renderableTag) {
            boolean result = super.add(renderableTag);
            NbtEditorScreen.this.reinitDeleteButtons();
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            NbtEditorScreen.this.reinitDeleteButtons();
        }
    };
    private final ScrollerManager<RenderableTag<?>> scrollerManager;
    private NbtPath path = new NbtPath.RootNbtPath();
    private TagRenderer<?> currentEnteredTag;
    private TagEditingOverlay overlay;
    private final Consumer<TagEditingOverlay> onTagReceived;
    private final List<SpriteImageButton> deleteButtons = new ArrayList<SpriteImageButton>(7);
    private String parseError;
    private boolean editorLocked;

    protected NbtEditorScreen() {
        super("nbt_editor_screen", new ScreenPosition(204, 191));
        this.scrollerManager = new ScrollerManager(() -> this.leftPos + 181, () -> this.topPos + 41, 138, 1, 7, this.renderables, SCOLLER);
        this.onTagEdited = () -> {
            this.tagBox.m_94144_(this.editingTag.toString());
            this.onTagEdited(this.editingTag.m_6426_());
        };
        this.onTagReceived = this::setOverlay;
    }

    public void setNewTag(CompoundTag tag) {
        if (!this.initialized) {
            return;
        }
        this.overlay = null;
        if (tag != null) {
            this.editingTag = tag.m_6426_();
            this.tagBox.m_94144_(this.editingTag.toString());
            if (!this.editorLocked) {
                TagRenderer<?> renderer = this.getTagByPath();
                if (renderer == null || !renderer.canEnterInTag()) {
                    this.path = new NbtPath.RootNbtPath();
                }
                this.initList(false);
            }
        } else {
            this.editingTag = null;
            this.scrollerManager.setMainList(new ArrayList());
            this.scrollerManager.setScrollOffset(0.0f);
            this.scrollerManager.refreshList();
            this.tagBox.m_94144_("");
            this.pathExit.f_93624_ = false;
        }
        this.parseError = null;
    }

    private void setOverlay(TagEditingOverlay tagEditor) {
        this.overlay = tagEditor;
        if (tagEditor != null) {
            tagEditor.init(this.f_96543_, this.f_96544_, this::setOverlay);
        }
    }

    protected abstract void onTagEdited(CompoundTag var1);

    protected int getWaitingColor() {
        return FastColor.ARGB32.m_13660_((int)255, (int)198, (int)198, (int)198);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
        void var6_11;
        super.m_88315_(guiGraphics, mouseX, mouseY, tick);
        if (this.editingTag == null) {
            this.gui.fill(this.leftPos + 4, this.topPos + 4, this.leftPos + this.imageLength - 4, this.topPos + this.imageHeight - 4, this.getWaitingColor());
            int x = this.leftPos + this.imageLength / 2;
            int n = this.topPos + this.imageHeight / 2;
            this.gui.drawCenteredString((Component)Component.m_237115_((String)"blockomorph.gui.nbtEditor.waitingTag"), x, n, -1, true);
            this.gui.drawCenteredString((Component)Component.m_237113_((String)LoadingDotsText.m_232744_((long)Util.m_137550_())), x, n + 10, -8355712, true);
            return;
        }
        for (Button button : this.deleteButtons) {
            button.m_88315_(guiGraphics, mouseX, mouseY, tick);
        }
        int i = 0;
        Object var6_10 = null;
        for (RenderableTag<?> tag : this.renderables) {
            tag.render(this.gui, i * 20);
            ++i;
            if (var6_11 != null) continue;
            Component component = tag.getTooltip(this.gui);
        }
        this.renderError();
        if (this.overlay != null) {
            this.gui.renderInDepthIfNeededAfterBlockRendering(() -> {
                this.gui.blurScreen(this.f_96543_, this.f_96544_, 190);
                this.overlay.render(this.gui);
            });
        } else if (var6_11 != null) {
            this.gui.renderTooltip((Component)var6_11, mouseX, mouseY);
        }
    }

    private void renderError() {
        if (this.parseError != null) {
            int y = this.topPos + this.imageHeight;
            if (this.f_96547_.m_92895_(this.parseError) > this.f_96543_) {
                int textLength = this.f_96547_.m_92895_(this.parseError);
                int x2 = -(textLength - this.f_96543_);
                this.gui.fill(0, y, this.f_96543_, y + 11, Integer.MIN_VALUE);
                this.gui.drawString((Component)Component.m_237113_((String)this.parseError).m_130940_(ChatFormatting.RED), x2, y + 2, -1, true);
            } else {
                this.gui.drawCenteredStringWithAdditional((Component)Component.m_237113_((String)this.parseError).m_130940_(ChatFormatting.RED), this.f_96543_ / 2, y + 2, -1, false, (x, length) -> this.gui.fill(x - 1, y, x + length + 1, y + 11, Integer.MIN_VALUE));
            }
        }
    }

    public void setEditorLocked(boolean yes) {
        this.editorLocked = yes;
        if (yes) {
            this.path = new NbtPath.RootNbtPath();
            this.pathExit.f_93624_ = false;
            this.scrollerManager.setMainList(new ArrayList());
            this.scrollerManager.setScrollOffset(0.0f);
            this.scrollerManager.refreshList();
        } else {
            this.enterInTag(new NbtPath.RootNbtPath(), false);
        }
        this.addButton.f_93624_ = !yes;
        this.restoreButton.f_93624_ = yes && this.editingTag != null;
    }

    public void setError(String errorMessage) {
        this.parseError = errorMessage;
    }

    public boolean m_6375_(double mouseX, double mouseY, int type) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.m_6375_(mouseX, mouseY, type);
        }
        if (type == 0) {
            if (this.forEachTag(renderer -> renderer.mouseClicked(mouseX, mouseY))) {
                this.tagBox.m_93692_(false);
                return true;
            }
            for (Button button : this.deleteButtons) {
                if (!button.m_6375_(mouseX, mouseY, type)) continue;
                this.tagBox.m_93692_(false);
                return true;
            }
        }
        this.tagBox.m_93692_(this.tagBox.m_5953_(mouseX, mouseY));
        if (super.m_6375_(mouseX, mouseY, type)) {
            return true;
        }
        return this.scrollerManager.mouseClicked(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int type, double mouseXOffset, double mouseYOffset) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.m_7979_(mouseX, mouseY, type, mouseXOffset, mouseYOffset);
        }
        if (this.scrollerManager.mouseDragged(mouseY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, type, mouseXOffset, mouseYOffset);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double yWheelOffset) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.m_6050_(mouseX, mouseY, yWheelOffset);
        }
        if (this.forEachTag(renderer -> renderer.mouseScrolled(mouseX, mouseY, yWheelOffset))) {
            return true;
        }
        return this.scrollerManager.mouseScrolled(yWheelOffset);
    }

    public boolean m_6348_(double mouseX, double mouseY, int type) {
        if (this.editingTag == null) {
            return false;
        }
        this.scrollerManager.disableScrollWork();
        if (this.overlay != null) {
            this.overlay.m_6348_(mouseX, mouseY, type);
        }
        return super.m_6348_(mouseX, mouseY, type);
    }

    public boolean m_5534_(char character, int mods) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.m_5534_(character, mods);
        }
        if (this.forEachTag(renderer -> renderer.charTyped(character, mods))) {
            return true;
        }
        return super.m_5534_(character, mods);
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (this.editingTag == null) {
            if (key == 256 && this.m_6913_()) {
                this.m_7379_();
                return true;
            }
            return false;
        }
        if (this.overlay != null) {
            if (key == 256) {
                this.onTagReceived.accept(null);
                return true;
            }
            return this.overlay.m_7933_(key, scancode, mods);
        }
        if (this.forEachTag(renderer -> renderer.keyPressed(key, scancode, mods))) {
            return true;
        }
        return super.m_7933_(key, scancode, mods);
    }

    private boolean forEachTag(Function<RenderableTag<?>, Boolean> action) {
        for (RenderableTag<?> renderer : this.renderables) {
            if (!action.apply(renderer).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderMenu() {
        int color = this.path.isEmpty() ? FastColor.ARGB32.m_13660_((int)255, (int)84, (int)84, (int)84) : this.currentEnteredTag.getFrameColor();
        this.gui.fill(this.internalBoxX, this.internalBoxY, this.internalBoxX + this.internalBoxLength, this.internalBoxY + this.internalBoxHeigth, color);
        super.renderMenu();
        this.scrollerManager.renderScroller(this.gui);
        this.gui.drawString((Component)Component.m_237113_((String)this.path.getVisualString()), this.internalBoxX + 11, this.internalBoxY + 5, -1, false);
        if (this.editorLocked) {
            this.gui.blitMonoImage(LOCK_IMAGE, this.internalBoxX, this.internalBoxY, this.internalBoxLength, this.internalBoxHeigth);
        }
    }

    private void parseTagboxInput(String value) {
        if (this.editingTag == null) {
            return;
        }
        if (!value.equals(this.editingTag.toString())) {
            try {
                this.editingTag = TagParser.m_129359_((String)value);
                this.setEditorLocked(false);
                this.onTagEdited(this.editingTag.m_6426_());
                this.parseError = null;
            }
            catch (CommandSyntaxException e) {
                this.parseError = e.getMessage();
                this.setEditorLocked(true);
            }
        } else {
            this.parseError = null;
            if (this.editorLocked) {
                this.setEditorLocked(false);
            }
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.internalBoxX = this.leftPos + 23;
        this.internalBoxY = this.topPos + 26;
        if (!this.initialized) {
            this.tagBox = new ListenerEditBox(this.f_96547_, 0, 0, 129, 19, this.m_96636_(), this::parseTagboxInput, ListenerEditBox.EDITBOX_BORDER_SPRITE);
            this.tagBox.m_94199_(32000);
        }
        this.tagBox.m_264152_(this.leftPos + 23, this.topPos + 5);
        this.m_142416_((GuiEventListener)this.tagBox);
        if (!this.initialized) {
            this.addButton = new SpriteImageButton(0, 0, 16, 16, BUTTONS_SPRITE, b -> {
                TagEditingOverlay addOverlay = this.currentEnteredTag.getTagAddOverlay();
                if (addOverlay != null) {
                    this.setOverlay(addOverlay);
                }
            }, null, false, 0, 0, 46, 43);
        }
        this.addButton.m_264152_(this.leftPos + 177, this.topPos + 6);
        this.m_142416_((GuiEventListener)this.addButton);
        if (!this.initialized) {
            MutableComponent text = Component.m_237115_((String)"blockomorph.gui.nbtEditor.restore");
            int textWidth = this.f_96547_.m_92852_((FormattedText)text);
            this.restoreButton = Button.m_253074_((Component)text, b -> {
                this.tagBox.m_94144_(this.editingTag.toString());
                this.setEditorLocked(false);
                this.parseError = null;
            }).m_253046_(textWidth + 6, 20).m_253136_();
            this.restoreButton.f_93624_ = false;
            this.m_142416_((GuiEventListener)this.restoreButton);
        }
        this.restoreButton.m_264152_(this.internalBoxX + this.internalBoxLength / 2 - this.restoreButton.m_5711_() / 2, this.internalBoxY + 112);
        if (!this.initialized) {
            this.pathExit = Button.m_253074_((Component)Component.m_237113_((String)"<--"), button -> this.enterInTag(this.path.back(), false)).m_253046_(22, 9).m_253136_();
            this.pathExit.f_93624_ = false;
        }
        this.pathExit.m_264152_(this.internalBoxX + 146, this.internalBoxY + 4);
        this.m_142416_((GuiEventListener)this.pathExit);
        if (this.initialized) {
            this.reinitDeleteButtons();
        }
        if (this.overlay != null) {
            this.overlay.init(this.f_96543_, this.f_96544_, this::setOverlay);
        }
        this.initialized = true;
    }

    public void enterInTag(NbtPath path, boolean intr) {
        this.path = path;
        this.initList(intr);
    }

    @Nullable
    private TagRenderer<?> getTagByPath() {
        CompoundTag root = this.editingTag;
        String previousName = "root";
        for (String tagName : this.path.constructPath(new ArrayList<String>())) {
            Tag child;
            TagRenderer<CompoundTag> renderer = TagTypes.getRendererForTag(previousName, root, new TagRendererContext(this.provider(), this.onEntering, this.onTagEdited, this.onTagReceived, this::softEnteredTagRebuild));
            if (renderer != null && (child = renderer.tryWalk(tagName)) != null) {
                root = child;
                previousName = tagName;
                continue;
            }
            return null;
        }
        return TagTypes.getRendererForTag(previousName, root, new TagRendererContext(this.provider(), this.onEntering, this.onTagEdited, this.onTagReceived, this::softEnteredTagRebuild));
    }

    private void initList(boolean interpretationEnd) {
        TagRenderer<?> rootRenderer = this.getTagByPath();
        if (rootRenderer == null) {
            throw new IllegalArgumentException("Illegal path: " + this.path + " for tag: " + this.editingTag);
        }
        if (interpretationEnd) {
            rootRenderer = Objects.requireNonNullElse(rootRenderer.getInterpretationRenderer(null), rootRenderer);
        }
        if (rootRenderer.canEnterInTag()) {
            this.currentEnteredTag = rootRenderer;
            ArrayList renderableTags = new ArrayList();
            for (TagRenderer<?> renderer : rootRenderer.getEnteringTags()) {
                renderableTags.add(new RenderableTag(renderer));
            }
            this.scrollerManager.setMainList(renderableTags.stream().filter(RenderableTag::isValid).toList());
            this.scrollerManager.setScrollOffset(0.0f);
            this.scrollerManager.refreshList();
            this.pathExit.f_93624_ = !this.path.isEmpty();
            return;
        }
        throw new IllegalArgumentException("Tag: " + rootRenderer.getTag().m_6458_().m_5987_() + " no enterable!");
    }

    private void softEnteredTagRebuild(HashMap<String, String> mappings) {
        List<String> nonInterpretation = Objects.requireNonNull(this.scrollerManager.getMainList()).stream().map(renderableTag -> {
            if (renderableTag.interpretationDisabled) {
                return (String)mappings.get(renderableTag.mainRenderer.getName());
            }
            return null;
        }).filter(Objects::nonNull).toList();
        ArrayList renderableTags = new ArrayList();
        for (TagRenderer<?> renderer : this.currentEnteredTag.getEnteringTags()) {
            RenderableTag tag = new RenderableTag(renderer);
            renderableTags.add(tag);
            if (!nonInterpretation.contains(tag.mainRenderer.getName())) continue;
            tag.disableInterpretation.run();
        }
        this.scrollerManager.setMainList(renderableTags.stream().filter(RenderableTag::isValid).toList());
        if (this.scrollerManager.getMainList().size() <= 7) {
            this.scrollerManager.setScrollOffset(0.0f);
        }
        this.scrollerManager.refreshList();
    }

    private void reinitDeleteButtons() {
        this.deleteButtons.clear();
        int i = 0;
        for (RenderableTag<?> tag : this.renderables) {
            this.deleteButtons.add(new SpriteImageButton(this.leftPos + 5, this.topPos + 42 + i * 20, 16, 16, BUTTONS_SPRITE, b -> {
                String name = tag.mainRenderer.getName();
                this.currentEnteredTag.deleteTag(name);
            }, null, false, 16, 0, 46, 43));
            ++i;
        }
    }

    private HolderGetter.Provider provider() {
        return GuiUtils.MC.f_91073_ != null ? GuiUtils.MC.f_91073_.m_9598_().m_255325_() : RegistryAccess.f_243945_.m_255325_();
    }

    private class RenderableTag<T extends Tag> {
        TagRenderer<T> mainRenderer;
        boolean interpretationDisabled;
        Runnable disableInterpretation;

        private RenderableTag(TagRenderer<T> renderer) {
            this.mainRenderer = renderer;
            if (this.mainRenderer != null) {
                this.disableInterpretation = () -> {
                    renderer.forceTagChange(this.mainRenderer.getTag());
                    this.mainRenderer = renderer;
                    this.interpretationDisabled = true;
                };
                AbstractInterpritationTagRenderer<T> additionalRenderer = renderer.getInterpretationRenderer(this.disableInterpretation);
                if (additionalRenderer != null) {
                    this.mainRenderer = additionalRenderer;
                }
            }
        }

        public boolean isValid() {
            return this.mainRenderer != null;
        }

        public void render(GuiUtils gui, int yOffset) {
            this.mainRenderer.getBox().m_173049_(NbtEditorScreen.this.internalBoxX + 10, NbtEditorScreen.this.internalBoxY + 14 + yOffset);
            this.mainRenderer.renderTag(gui);
        }

        @Nullable
        public Component getTooltip(GuiUtils gui) {
            return this.mainRenderer.getTooltip(gui);
        }

        public boolean mouseClicked(double mouseX, double mouseY) {
            return this.mainRenderer.mouseClicked(mouseX, mouseY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double yOffsetWheel) {
            return this.mainRenderer.mouseScrolled(mouseX, mouseY, yOffsetWheel);
        }

        public boolean keyPressed(int key, int scancode, int mods) {
            return this.mainRenderer.keyPressed(key, scancode, mods);
        }

        public boolean charTyped(char character, int mods) {
            return this.mainRenderer.charTyped(character, mods);
        }
    }
}

