/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor;

import net.blockomorph.network.ServerBoundBlockMorphPacket;
import net.blockomorph.network.ServerBoundSelfNbtRequestPacket;
import net.blockomorph.screens.morph.ConfigSyncListener;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtEditorScreen;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.SpriteImageButton;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PlayerBlockEntityNbtEditor
extends NbtEditorScreen
implements ConfigSyncListener {
    private static final ResourceLocation BUTTON_REFRESH = GuiUtils.res("textures/screens/nbt_request.png");
    protected boolean init;
    private final Screen parentScreen;
    private Button exit;

    public PlayerBlockEntityNbtEditor(Screen old) {
        this.parentScreen = old;
    }

    private PlayerAccessor getPlayer() {
        return PlayerAccessor.of((Player)GuiUtils.MC.f_91074_);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int type) {
        if (this.exit.m_6375_(mouseX, mouseY, type)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, type);
    }

    @Override
    protected void onTagEdited(CompoundTag tag) {
        MorphUtils.sendServer(ServerBoundBlockMorphPacket.create(this.getPlayer().getBlockState(InPlayerBlockPos.ZERO), tag));
        this.setError(null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (!this.init) {
            MorphUtils.sendServer(new ServerBoundSelfNbtRequestPacket());
            this.init = true;
        }
        SpriteImageButton refreshButton = new SpriteImageButton(this.leftPos + 156, this.topPos + 6, 16, 16, BUTTON_REFRESH, b -> {
            MorphUtils.sendServer(new ServerBoundSelfNbtRequestPacket());
            this.setNewTag(null);
        }, null, false);
        refreshButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"blockomorph.gui.nbtEditor.blockEntity.button.refresh.tooltip")));
        this.m_142416_((GuiEventListener)refreshButton);
        Button done = Button.m_253074_((Component)Component.m_237113_((String)"<--"), b -> GuiUtils.MC.m_91152_(this.parentScreen)).m_252794_(this.leftPos - 25, this.topPos).m_253046_(20, 20).m_253136_();
        this.m_142416_((GuiEventListener)done);
        this.exit = done;
    }

    @Override
    public void onConfigSynced() {
        if (BannedBlock.isBannedBlock(this.getPlayer().getBlockState(InPlayerBlockPos.ZERO), this.getPlayer(), BannedBlock.Source.NETWORK) != null) {
            this.m_7379_();
        } else {
            Config.ScreenAccess access = MorphUtils.getScreenAccess((Player)GuiUtils.MC.f_91074_);
            if (!access.config) {
                this.m_7379_();
            }
        }
    }
}

