/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CollectionTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CompoundTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.NumericTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.StringTagRenderer;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import org.jetbrains.annotations.Nullable;

public class TagTypes {
    private static final HashMap<TagType<?>, TagRendererFactory<?>> RENDERERS = new HashMap();
    private static final HashMap<TagType<?>, Supplier<?>> TAGS = new HashMap();

    public static <T extends Tag> void registerRenderer(TagType<T> type, TagRendererFactory<T> factory) {
        if (RENDERERS.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type.m_5987_() + " already registered!");
        }
        RENDERERS.put(type, factory);
    }

    public static <T extends Tag> void registerTagCreator(TagType<T> type, Supplier<T> creator) {
        if (TAGS.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type.m_5987_() + " already registered!");
        }
        TAGS.put(type, creator);
    }

    public static TagType<?>[] getRegisteredTags() {
        TagType[] array = new TagType[TAGS.size()];
        int i = 0;
        Iterator<TagType<?>> iterator = TAGS.keySet().iterator();
        while (iterator.hasNext()) {
            TagType<?> tagType;
            array[i] = tagType = iterator.next();
            ++i;
        }
        return array;
    }

    @Nullable
    public static <T extends Tag> TagRenderer<T> getRendererForTag(String name, T tag, TagRendererContext<T> ctx) {
        try {
            TagRendererFactory<?> renderSource = RENDERERS.get(tag.m_6458_());
            if (renderSource != null) {
                return renderSource.create(name, tag, ctx);
            }
        }
        catch (ClassCastException e) {
            MorphUtils.LOGGER.error("Invalid tag registration for NBT Editor: ", (Throwable)e);
            return null;
        }
        return null;
    }

    public static <T extends Tag> Supplier<T> createDefaultTag(TagType<T> type) {
        try {
            return TAGS.get(type);
        }
        catch (Exception e) {
            MorphUtils.LOGGER.error("Invalid tag registration for NBT Editor: ", (Throwable)e);
            return null;
        }
    }

    static {
        TagTypes.registerRenderer(CompoundTag.f_128326_, CompoundTagRenderer::new);
        TagTypes.registerRenderer(StringTag.f_129288_, StringTagRenderer::new);
        TagTypes.registerRenderer(IntTag.f_128670_, NumericTagRenderer.IntTagRenderer::new);
        TagTypes.registerRenderer(LongTag.f_128873_, NumericTagRenderer.LongTagRenderer::new);
        TagTypes.registerRenderer(DoubleTag.f_128494_, NumericTagRenderer.DoubleTagRenderer::new);
        TagTypes.registerRenderer(FloatTag.f_128560_, NumericTagRenderer.FloatTagRenderer::new);
        TagTypes.registerRenderer(ShortTag.f_129244_, NumericTagRenderer.ShortTagRenderer::new);
        TagTypes.registerRenderer(ByteTag.f_128255_, NumericTagRenderer.ByteTagRenderer::new);
        TagTypes.registerRenderer(ListTag.f_128714_, CollectionTagRenderer.ListTagRenderer::new);
        TagTypes.registerRenderer(IntArrayTag.f_128599_, CollectionTagRenderer.IntArrayTagRenderer::new);
        TagTypes.registerRenderer(LongArrayTag.f_128800_, CollectionTagRenderer.LongArrayTagRenderer::new);
        TagTypes.registerRenderer(ByteArrayTag.f_128185_, CollectionTagRenderer.ByteArrayTagRenderer::new);
        TagTypes.registerTagCreator(StringTag.f_129288_, () -> StringTag.m_129297_((String)""));
        TagTypes.registerTagCreator(CompoundTag.f_128326_, CompoundTag::new);
        TagTypes.registerTagCreator(ListTag.f_128714_, ListTag::new);
        TagTypes.registerTagCreator(IntArrayTag.f_128599_, () -> new IntArrayTag(new int[0]));
        TagTypes.registerTagCreator(LongArrayTag.f_128800_, () -> new LongArrayTag(new long[0]));
        TagTypes.registerTagCreator(ByteArrayTag.f_128185_, () -> new ByteArrayTag(new byte[0]));
        TagTypes.registerTagCreator(IntTag.f_128670_, () -> IntTag.m_128679_((int)0));
        TagTypes.registerTagCreator(LongTag.f_128873_, () -> LongTag.m_128882_((long)0L));
        TagTypes.registerTagCreator(DoubleTag.f_128494_, () -> DoubleTag.m_128500_((double)0.0));
        TagTypes.registerTagCreator(FloatTag.f_128560_, () -> FloatTag.m_128566_((float)0.0f));
        TagTypes.registerTagCreator(ShortTag.f_129244_, () -> ShortTag.m_129258_((short)0));
        TagTypes.registerTagCreator(ByteTag.f_128255_, () -> ByteTag.m_128266_((byte)0));
    }

    @FunctionalInterface
    public static interface TagRendererFactory<T extends Tag> {
        public TagRenderer<T> create(String var1, T var2, TagRendererContext<T> var3);
    }
}

