/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtEditorScreen;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ObjectListRenderer;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TagAddingOverlay<T extends Tag>
extends TagEditingOverlay {
    private static final ResourceLocation MENU = GuiUtils.res("textures/screens/tag_adding_screen.png");
    private int tagBoxX;
    private int tagBoxY;
    private final ObjectListRenderer<TagTypes, TagType<? extends T>> selector;
    private final BiConsumer<String, T> onTagCreated;
    private CachedType<? extends T> currentType;
    private final TagType<? extends T> first;
    @Nullable
    private final Supplier<String> nameSuggestion;
    @Nullable
    private final List<Component> hint;
    private int leftPos;
    private int topPos;
    private final boolean listDisabled;
    private final Predicate<String> filter;
    private EditBox name;

    @SafeVarargs
    public TagAddingOverlay(Predicate<String> nameFilter, BiConsumer<String, T> onTagCreated, @Nullable Supplier<String> nameSuggestion, @Nullable List<Component> hint, boolean needInterpritation, TagType<? extends T> ... types) {
        super(159, 59);
        List<TagType<?>> registered = List.of(TagTypes.getRegisteredTags());
        List<TagType> filtered = Stream.of(types).filter(type -> {
            if (registered.contains(type)) {
                return true;
            }
            MorphUtils.LOGGER.error("Tag " + type.m_5987_() + " not registered and not be added!");
            return false;
        }).toList();
        if (filtered.isEmpty()) {
            throw new IllegalArgumentException("Types array is empty!");
        }
        this.selector = new ObjectListRenderer<TagTypes, TagType>(-1, -256, 7, (tagTypes, tagType) -> tagType.m_5986_().replace("TAG_", "").replace("_", " "), tagTypes -> filtered);
        this.onTagCreated = onTagCreated;
        this.listDisabled = filtered.size() == 1;
        this.filter = nameFilter;
        this.first = filtered.get(0);
        this.nameSuggestion = nameSuggestion;
        this.hint = hint;
    }

    private <TAG extends T> void setCurrentType(TagType<TAG> type) {
        Supplier<TAG> creator = TagTypes.createDefaultTag(type);
        this.currentType = new CachedType<Tag>(type, creator, TagTypes.getRendererForTag(null, (Tag)Objects.requireNonNull(creator).get(), null));
        this.currentType.renderer.getBox().m_173049_(this.tagBoxX, this.tagBoxY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int type) {
        if (type == 0) {
            if (!this.listDisabled) {
                int x = this.tagBoxX;
                int y = this.tagBoxY;
                if (this.selector.mouseClicked(mouseX, mouseY)) {
                    return true;
                }
                if (GuiUtils.isMouseOver(x, y, x + 54, y + 20, mouseX, mouseY)) {
                    this.selector.drop(null, tagType -> {
                        GuiUtils.playClickSound();
                        this.setCurrentType((TagType)tagType);
                    });
                    GuiUtils.playClickSound();
                    return true;
                }
                this.selector.close();
            }
            return super.m_6375_(mouseX, mouseY, 0);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double yWheelOffset) {
        return this.selector.mouseScrolled(mouseX, mouseY, yWheelOffset);
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (key == 257) {
            this.acceptTag();
            GuiUtils.playClickSound();
            return true;
        }
        return super.m_7933_(key, scancode, mods);
    }

    @Override
    protected void renderInGui(GuiUtils gui) {
        int x = this.tagBoxX + 6;
        int y = this.tagBoxY + 6;
        this.selector.renderName(gui, x, y, 38, null, this.currentType.type, -1);
        this.selector.render(gui, x, y, -1, 10);
        if (this.nameSuggestion != null && this.name.m_94155_().isEmpty() && !this.name.m_274382_()) {
            gui.drawString((Component)Component.m_237113_((String)this.nameSuggestion.get()), this.name.m_252754_() + 4, this.name.m_252907_() + (this.name.m_93694_() - 8) / 2, -8355712, true);
        }
        if (this.hint != null && this.name.m_274382_()) {
            int n = this.hint.size();
            Objects.requireNonNull(gui.getFont());
            int height = 6 + n * 9 + 18;
            gui.renderTooltip(this.hint, this.name.m_252754_() - 12, this.name.m_252907_() - height + 12);
        }
    }

    public void acceptTag() {
        Tag tag = (Tag)this.currentType.creator.get();
        this.onTagCreated.accept(this.name.m_94155_(), (String)tag);
        this.onChange.accept(null);
    }

    @Override
    protected void renderBackground(GuiUtils gui) {
        TagRenderer renderer = this.currentType.renderer;
        gui.blitMonoImage(MENU, this.leftPos, this.topPos, this.imageLength, this.imageHeight);
        gui.enableScrissors(this.tagBoxX, this.tagBoxY, this.tagBoxX + 50, this.tagBoxY + 20);
        renderer.renderPlateWithoutCtx(gui);
        gui.disableScrissors();
        int x = this.tagBoxX + 50;
        gui.enableScrissors(x, this.tagBoxY, x + 4, this.tagBoxY + 20);
        int plateX = x - (renderer.getBox().m_110090_() - 4);
        int oldX = renderer.getBox().m_110085_();
        renderer.getBox().m_173047_(plateX);
        renderer.renderPlateWithoutCtx(gui);
        renderer.getBox().m_173047_(oldX);
        gui.disableScrissors();
        gui.blit(NbtEditorScreen.BUTTONS_SPRITE, this.tagBoxX + 4, this.tagBoxY + 4, 0.0f, 32.0f, 46, 11, 46, 43);
    }

    @Override
    public void init(int width, int height, Consumer<TagEditingOverlay> onChange) {
        super.init(width, height, onChange);
        this.leftPos = (this.width - this.imageLength) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.tagBoxX = this.leftPos + 99;
        this.tagBoxY = this.topPos + 7;
        if (this.currentType == null) {
            this.setCurrentType(this.first);
        }
        this.currentType.renderer.getBox().m_173049_(this.tagBoxX, this.tagBoxY);
        String nameValue = this.name != null ? this.name.m_94155_() : "";
        this.name = new EditBox(GuiUtils.MC.f_91062_, this.leftPos + 7, this.topPos + 7, 89, 20, (Component)Component.m_237113_((String)"name"));
        this.name.m_94153_(this.filter);
        this.addRenderableWidget((AbstractWidget)this.name);
        this.name.m_94144_(nameValue);
        Button done = new Button(this.leftPos + 7, this.topPos + 32, 146, 20, CommonComponents.f_130655_, b -> this.acceptTag(), Supplier::get){

            protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
                this.f_93622_ = this.m_5953_(mouseX, mouseY) && !TagAddingOverlay.this.selector.isListFocused(mouseX, mouseY);
                super.m_87963_(guiGraphics, mouseX, mouseY, tick);
            }
        };
        this.addRenderableWidget((AbstractWidget)done);
        this.m_7522_((GuiEventListener)this.name);
    }

    private record CachedType<T extends Tag>(TagType<T> type, Supplier<T> creator, TagRenderer<T> renderer) {
    }
}

