/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.blockstate;

import java.util.function.Consumer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.blockstate.BlockTypeSelectorOverlay;
import net.blockomorph.screens.morphConfig.propertiesWidget.BlockStatePropsRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateSelectorOverlay
extends TagEditingOverlay {
    private final Consumer<BlockState> handler;
    private BlockState state;
    private BlockEntity tempBE;
    private int leftPos;
    private int topPos;
    private static final ResourceLocation MENU = GuiUtils.res("textures/screens/state_selector.png");
    private BlockStatePropsRenderer propsRenderer;
    private Button exit;
    private Button typeEdit;

    public BlockStateSelectorOverlay(BlockState state, Consumer<BlockState> handler) {
        super(159, 131);
        this.handler = handler;
        this.state = state;
        this.setTempBE();
    }

    private void setTempBE() {
        Block block = this.state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            v0 = ent.m_142194_(GuiUtils.AIR, this.state);
        } else {
            v0 = this.tempBE = null;
        }
        if (this.tempBE != null) {
            this.tempBE.m_142339_((Level)GuiUtils.MC.f_91073_);
        }
    }

    @Override
    public void renderInGui(GuiUtils gui) {
        gui.renderBlockInGui(this.state, this.tempBE, (float)this.leftPos + 63.85f, (float)this.topPos + 64.0f, 36.0f);
        gui.renderAdditionalOnBlock(this.state, (float)this.leftPos + 30.5f, (float)this.topPos + 40.5f, 55.0f);
        this.propsRenderer.render(gui);
        String[] text = Component.m_237115_((String)"blockomorph.gui.stateSelectorOverlay.selectBlock").getString().split("\n");
        int x = this.leftPos + 8 + this.typeEdit.m_5711_() / 2;
        gui.drawCenteredString((Component)Component.m_237113_((String)text[0]), x, this.topPos + 84, -1, true);
        gui.drawCenteredString((Component)Component.m_237113_((String)text[1]), x, this.topPos + 93, -1, true);
        if (GuiUtils.isMouseOver(this.leftPos + 8, this.topPos + 18, this.leftPos + 69, this.topPos + 79, gui.getMouseX(), gui.getMouseY())) {
            gui.renderTooltip((Component)this.state.m_60734_().m_49954_(), gui.getMouseX(), gui.getMouseY());
        }
    }

    @Override
    protected void renderBackground(GuiUtils gui) {
        gui.blitMonoImage(MENU, this.leftPos, this.topPos, this.imageLength, this.imageHeight);
        this.renderString(gui);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int type) {
        if (type == 0) {
            if (super.m_6375_(mouseX, mouseY, type)) {
                return true;
            }
            return this.propsRenderer.mouseClicked(mouseX, mouseY, type);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double yWheelOffset) {
        return this.propsRenderer.mouseScrolled(mouseX, mouseY, yWheelOffset);
    }

    private void renderString(GuiUtils gui) {
        Object blockName = this.state.m_60734_().m_49954_().getString();
        if (gui.getFont().m_92895_((String)blockName) > 68) {
            blockName = gui.getFont().m_92834_((String)blockName, 62) + "...";
        }
        gui.drawString((Component)Component.m_237113_((String)blockName), this.leftPos + 6, this.topPos + 6, 0x404040, false);
        gui.drawString((Component)Component.m_237113_((String)"BlockState"), this.leftPos + 83, this.topPos + 11, 0x404040, false);
    }

    private void changeBlockState(BlockState newState) {
        this.state = newState;
        this.setTempBE();
        this.handler.accept(newState);
    }

    @Override
    public void init(int width, int height, Consumer<TagEditingOverlay> onChange) {
        super.init(width, height, onChange);
        this.leftPos = (this.width - this.imageLength) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.propsRenderer = new BlockStatePropsRenderer(this.leftPos + 79, this.topPos + 20, 5, () -> this.state, this::changeBlockState);
        this.exit = Button.m_253074_((Component)CommonComponents.f_130655_, b -> onChange.accept(null)).m_252987_(this.leftPos + 8, this.topPos + 105, 61, 20).m_253136_();
        this.addRenderableWidget((AbstractWidget)this.exit);
        this.typeEdit = Button.m_253074_((Component)CommonComponents.f_237098_, b -> onChange.accept(new BlockTypeSelectorOverlay(block -> {
            onChange.accept(this);
            this.changeBlockState((BlockState)block);
        }))).m_252987_(this.leftPos + 8, this.topPos + 82, 61, 20).m_253136_();
        this.addRenderableWidget((AbstractWidget)this.typeEdit);
    }
}

