/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.AbstractInterpritationTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.BlockStateTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagAddingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;

public class CompoundTagRenderer
extends TagRenderer<CompoundTag> {
    private static final int BUTTON_SIZE = 16;
    private boolean hovered;

    public CompoundTagRenderer(String tagName, CompoundTag tag, TagRendererContext<CompoundTag> ctx) {
        super(tagName, tag, ctx);
    }

    @Override
    public void render(GuiUtils gui) {
        int x = this.box.m_110085_() + (this.hasName() ? 61 : this.box.m_110090_() - 3 - 16);
        int y = this.box.m_110086_() + 2;
        this.hovered = GuiUtils.isMouseOver(x, y, x + 16, y + 16, gui.getMouseX(), gui.getMouseY());
        gui.blit(TAGS_SPRITE, x, y, 144.0f, this.hovered ? 16.0f : 0.0f, 16, 16, 194, 200);
    }

    @Override
    public boolean canEnterInTag() {
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.hovered) {
            this.enterInTag();
            GuiUtils.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    public int getFrameColor() {
        return FastColor.ARGB32.m_13660_((int)255, (int)210, (int)166, (int)132);
    }

    @Override
    public List<TagRenderer<?>> getEnteringTags() {
        ArrayList renderers = new ArrayList();
        for (String key : ((CompoundTag)this.getTag()).m_128431_()) {
            Tag tag = ((CompoundTag)this.getTag()).m_128423_(key);
            if (tag == null) {
                throw new NullPointerException();
            }
            renderers.add(TagTypes.getRendererForTag(key, tag, this.tagRendererContext.withTagUpdateListener(newTag -> ((CompoundTag)this.getTag()).m_128365_(key, newTag))));
        }
        return renderers;
    }

    @Override
    public Tag tryWalk(String nameElementInThisTag) {
        return ((CompoundTag)this.getTag()).m_128423_(nameElementInThisTag);
    }

    @Override
    protected Integer getPlateNumber() {
        return 2;
    }

    @Override
    public TagEditingOverlay getTagAddOverlay() {
        return new TagAddingOverlay<Tag>(Objects::nonNull, (name, tag) -> {
            ((CompoundTag)this.getTag()).m_128365_(name, tag);
            this.signalChange();
        }, () -> "Tag name", null, true, TagTypes.getRegisteredTags());
    }

    @Override
    public void deleteTag(String name) {
        ((CompoundTag)this.getTag()).m_128473_(name);
        this.signalChange();
    }

    private void signalChange() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String tagName : ((CompoundTag)this.getTag()).m_128431_()) {
            map.put(tagName, tagName);
        }
        this.tagRendererContext.onSoftRebuildRequested().accept(map);
        this.tagRendererContext.onMainTagEdited().run();
    }

    @Override
    public AbstractInterpritationTagRenderer<CompoundTag> getInterpretationRenderer(Runnable onInterpretationBrake) {
        CompoundTag self = (CompoundTag)this.getTag();
        if (self.m_128441_("Name")) {
            if (self.m_128441_("Properties") && self.m_128440_() == 2) {
                return this.getBlockStateRenderer(onInterpretationBrake);
            }
            if (MorphUtils.blockPredicate().test(self.m_128461_("Name")) && self.m_128440_() == 1) {
                return this.getBlockStateRenderer(onInterpretationBrake);
            }
        }
        return null;
    }

    private BlockStateTagRenderer getBlockStateRenderer(Runnable onInterpretationBrake) {
        return new BlockStateTagRenderer(this, this.tagRendererContext.forInterpretation(onInterpretationBrake));
    }
}

