/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.propertiesWidget.renderers;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.blockomorph.screens.morphConfig.propertiesWidget.PropertyRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ObjectListRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EnumPropertyRenderer<T extends Enum<T>>
implements PropertyRenderer<T, EnumProperty<T>> {
    private final ObjectListRenderer<EnumProperty<T>, T> RENDERER = new ObjectListRenderer<EnumProperty, Enum>(-1, -65281, 7, EnumProperty::m_6940_, property -> new ArrayList(property.m_6908_()));
    private boolean notClose;

    @Override
    public void renderBackground(GuiUtils gui, EnumProperty<T> property, T value, Rect2i box) {
        this.renderPlate(gui, box, 0);
        this.RENDERER.renderName(gui, box.m_110085_() + 41, box.m_110086_() + 6, 20, property, value, -12821534);
    }

    @Override
    public void render(GuiUtils gui, EnumProperty<T> property, T value, Rect2i box) {
        if (this.RENDERER.isCurrentProperty(property)) {
            this.RENDERER.render(gui, box.m_110085_() + 41, box.m_110086_() + 6, -1, 8);
        }
    }

    @Override
    public boolean mouseClicked(Consumer<BlockState> newStateHandler, BlockState state, EnumProperty<T> property, T value, double mouseX, double mouseY, Rect2i box) {
        if (this.RENDERER.isCurrentProperty(property) && this.RENDERER.mouseClicked(mouseX, mouseY)) {
            return true;
        }
        if (GuiUtils.isInBounds(box, mouseX, mouseY)) {
            this.RENDERER.drop(property, newValue -> {
                GuiUtils.playClickSound();
                BlockState newState = (BlockState)state.m_263224_((Property)property, (Comparable)((Object)newValue));
                newStateHandler.accept(newState);
            });
            GuiUtils.playClickSound();
            this.notClose = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(Consumer<BlockState> newStateHandler, BlockState state, EnumProperty<T> property, T value, double mouseX, double mouseY, double yOffsetWheel, Rect2i box) {
        if (this.RENDERER.isCurrentProperty(property)) {
            return this.RENDERER.mouseScrolled(mouseX, mouseY, yOffsetWheel);
        }
        return false;
    }

    @Override
    public boolean renderTooltip(GuiUtils gui, EnumProperty<T> property, T value, Rect2i box) {
        PropertyRenderer.super.renderTooltip(gui, property, value, box);
        if (this.RENDERER.isListFocused(gui.getMouseX(), gui.getMouseY())) {
            return this.RENDERER.isCurrentProperty(property);
        }
        if (GuiUtils.isMouseOver(box.m_110085_() + 36, box.m_110086_(), box.m_110085_() + box.m_110090_(), box.m_110086_() + box.m_110091_(), gui.getMouseX(), gui.getMouseY())) {
            String name = property.m_6940_(value);
            if (gui.getFont().m_92895_(name) > 20) {
                gui.renderTooltip((Component)Component.m_237113_((String)name), gui.getMouseX(), gui.getMouseY());
            }
        }
        return false;
    }

    @Override
    public void startClick() {
        this.notClose = false;
    }

    @Override
    public void endClick() {
        if (!this.notClose) {
            this.RENDERER.close();
        }
    }
}

