/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.overlay;

import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.utils.FogLiquidModifier;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;
import org.jetbrains.annotations.Nullable;

public class BlockHeartOverlay
implements Overlay {
    private static final ResourceLocation BAR_IMAGE = GuiUtils.res("textures/screens/icons.png");
    private static final ResourceLocation HEART_INNER = GuiUtils.res("textures/screens/empty_heart_inner.png");
    private static final ResourceLocation HEART_OUT = GuiUtils.res("textures/screens/empty_heart_out.png");
    private static final ResourceLocation HEART_OUT_ABS = GuiUtils.res("textures/screens/empty_heart_abs.png");

    @Override
    public void render(GuiUtils gui, int screenWidth, int screenHeight) {
        PlayerAccessor player;
        LocalPlayer localPlayer = GuiUtils.MC.f_91074_;
        if (localPlayer instanceof PlayerAccessor && (player = (PlayerAccessor)localPlayer).isActive() && GuiUtils.MC.f_91072_ != null && GuiUtils.MC.f_91072_.m_105205_()) {
            switch (Config.getInstance().getValue("hitReaction", Config.HitReaction.class)) {
                case MELEE: 
                case PROJECTILES: 
                case FULL_PVP: {
                    this.renderBlockHearts(player, gui, screenWidth, screenHeight);
                    break;
                }
                case BRAKING: {
                    this.renderBlockSharps(player, gui, screenWidth, screenHeight);
                    break;
                }
            }
        }
    }

    private void renderBlockSharps(PlayerAccessor player, GuiUtils gui, int screenWidth, int screenHeight) {
        int progress = player.getBiggestProgress();
        int x = screenWidth / 2 - 90;
        int y = screenHeight - 38;
        gui.blit(BAR_IMAGE, x - 1, y - 1, 0.0f, progress == 9 ? 9.0f : 0.0f, 81, 9, 81, 18);
        TextureData data = TextureData.get(player);
        for (int i = 0; i < 10; ++i) {
            if (i >= 9 - progress) continue;
            gui.renderFromSpriteClass(data.sprite, x + i * 8, y, 7, 7, data.tint);
        }
    }

    private void renderBlockHearts(PlayerAccessor player, GuiUtils gui, int screenWidth, int screenHeight) {
        int x = screenWidth / 2 - 91;
        int y = screenHeight - 39;
        TextureData data = TextureData.get(player);
        Player realPlayer = player.player();
        int hpCount = Mth.m_14167_((float)realPlayer.m_21223_());
        int maxHpCount = Mth.m_14167_((float)realPlayer.m_21233_());
        int absHp = Mth.m_14167_((float)realPlayer.m_6103_());
        int maxHearts = Mth.m_14167_((float)((float)maxHpCount / 2.0f)) + Mth.m_14167_((float)((float)absHp / 2.0f));
        int yCount = 0;
        int xCount = 0;
        int currentHp = 0;
        boolean absHearts = false;
        for (int i = 0; i < maxHearts; ++i) {
            Boolean bool = (hpCount -= 2) >= 0 ? Boolean.valueOf(false) : (hpCount == -1 ? Boolean.valueOf(true) : null);
            this.renderOneHeart(gui, x + xCount * 8, y - yCount * 10, data.sprite, bool, data.tint, absHearts);
            if (!absHearts && (currentHp += 2) >= maxHpCount) {
                hpCount = absHp;
                absHearts = true;
            }
            if (++xCount != 10) continue;
            xCount = 0;
            ++yCount;
        }
    }

    private void renderOneHeart(GuiUtils gui, int x, int y, TextureAtlasSprite sprite, @Nullable Boolean half, int alphaOverlay, boolean absHeart) {
        gui.blitMonoImage(HEART_INNER, x, y, 9, 9);
        if (half != null) {
            gui.enableScrissors(x + 1, y + 1, x + 8 + (half != false ? -3 : 0), y + 6);
            gui.renderFromSpriteClass(sprite, x + 1, y + 1, 7, 7, alphaOverlay);
            gui.disableScrissors();
            gui.enableScrissors(x + 3, y + 6, x + 6 + (half != false ? -1 : 0), y + 8);
            gui.renderFromSpriteClass(sprite, x + 1, y + 1, 7, 7, alphaOverlay);
            gui.disableScrissors();
        }
        gui.blitMonoImage(absHeart ? HEART_OUT_ABS : HEART_OUT, x, y, 9, 9);
    }

    private record TextureData(TextureAtlasSprite sprite, int tint) {
        static TextureData get(PlayerAccessor player) {
            TextureAtlasSprite sprite = GuiUtils.blockRenderer.m_110910_(player.getBlockState(InPlayerBlockPos.ZERO)).m_6160_();
            BlockInPlayer2 block = player.getBlocksData2().get(InPlayerBlockPos.ZERO);
            Integer tint = block != null && block.getBlockState().m_60734_() instanceof LiquidBlock ? FogLiquidModifier.getPlatformFluidTint(GuiUtils.MC.f_91074_.m_9236_(), block) : null;
            return new TextureData(sprite, tint != null ? 0xFF000000 | tint : -1);
        }
    }
}

