/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.SpriteAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;

public final class FogLiquidModifier {
    @Nullable
    public LiquidFogData getFog(Iterable<Entity> entities, boolean includeVanilla) {
        AtomicReference fogData = new AtomicReference();
        Camera camera = GuiUtils.MC.f_91063_.m_109153_();
        Camera.NearPlane nearPlane = camera.m_167684_();
        for (Vec3 pos : Arrays.asList(nearPlane.m_167695_(0.0f, 0.0f), nearPlane.m_167694_(), nearPlane.m_167698_(), nearPlane.m_167699_(), nearPlane.m_167700_())) {
            Vec3 position = camera.m_90583_().m_82549_(pos);
            MorphUtils.doBlockInMorphedPlayerOnPos(camera.m_90592_(), entities, position, (pl, block) -> {
                if (block.shouldDoFluidAction()) {
                    FluidState fluidState = block.getBlockState().m_60819_();
                    if (includeVanilla || !fluidState.m_205070_(FluidTags.f_13131_) && !fluidState.m_205070_(FluidTags.f_13132_)) {
                        fogData.set(this.calculateData(camera.m_90592_().m_9236_(), (BlockInPlayer2)block));
                    }
                }
            });
        }
        return (LiquidFogData)fogData.get();
    }

    private LiquidFogData calculateData(Level lv, BlockInPlayer2 block) {
        try {
            Map.Entry<TextureAtlasSprite, Integer> info = FogLiquidModifier.getPlatformFluidTexture(lv, block);
            if (info.getKey() != null) {
                TextureAtlasSprite sprite = info.getKey();
                NativeImage image = SpriteAccessor.of(sprite.m_245424_()).getImage();
                int argbPixel = image.m_84985_(image.m_84982_() / 2, image.m_85084_() / 2);
                if (info.getValue() != null) {
                    argbPixel = FastColor.ARGB32.m_269105_((float)0.5f, (int)argbPixel, (int)info.getValue());
                }
                float start = -8.0f;
                float end = 36.0f;
                if (FastColor.ARGB32.m_13655_((int)argbPixel) > 235) {
                    start = 0.25f;
                    end = 1.0f;
                }
                return new LiquidFogData(start, end, argbPixel);
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    private static Map.Entry<TextureAtlasSprite, Integer> getPlatformFluidTexture(Level lv, BlockInPlayer2 block) {
        FluidState state = block.getBlockState().m_60819_();
        IClientFluidTypeExtensions info = IClientFluidTypeExtensions.of((FluidState)state);
        int tint = info.getTintColor(state, (BlockAndTintGetter)lv, block.getPos());
        TextureAtlasSprite[] atextureatlassprite = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)lv, (BlockPos)block.getPos(), (FluidState)state);
        return new AbstractMap.SimpleEntry<TextureAtlasSprite, Integer>(atextureatlassprite[0], tint == -1 ? null : Integer.valueOf(tint));
    }

    @Nullable
    public static Integer getPlatformFluidTint(Level lv, BlockInPlayer2 block) {
        FluidState state = block.getBlockState().m_60819_();
        IClientFluidTypeExtensions info = IClientFluidTypeExtensions.of((FluidState)state);
        int tint = info.getTintColor(state, (BlockAndTintGetter)lv, block.getPos());
        return tint == -1 ? null : Integer.valueOf(tint);
    }

    public record LiquidFogData(float start, float end, int color) {
    }
}

