/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.blockomorph.screens.overlay.BlockHeartOverlay;
import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.overlay.PlayerCrackOverlay;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuiUtils {
    private static final Function<ResourceLocation, RenderType> GUI_TEXTURE_WITH_ALPHA = Util.m_143827_(texture -> RenderType.m_173215_((String)"gui_texture_with_alpha", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172817_)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_gui_texture", GuiUtils::enableTextureRender, GuiUtils::disableTextureRender)).m_110663_(new RenderStateShard.DepthTestStateShard("<=", 515)).m_110691_(false)));
    private static final HashMap<Block, Boolean> BE_WITH_RENDERERS = new HashMap();
    public static final BlockPos AIR = new BlockPos(0, 500, 0);
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final List<Overlay> OVERLAYS = new ArrayList<Overlay>();
    private static final Vector3f DIFFUSE_LIGHT_START;
    private static final Vector3f DIFFUSE_LIGHT_END;
    public static final MultiBufferSource.BufferSource bufferSource;
    public static final BlockRenderDispatcher blockRenderer;
    public static final BlockEntityRenderDispatcher blockEntityRenderer;
    private GuiGraphics GUI;
    private int mouseX;
    private int mouseY;
    private float tick;
    private Font font;

    private static void enableTextureRender() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    private static void disableTextureRender() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static ResourceLocation res(String path) {
        return MorphUtils.res(path);
    }

    public static ResourceLocation vanillaRes(String path) {
        return MorphUtils.vanillaRes(path);
    }

    public void setGuiGraphics(GuiGraphics gui, Font font, int mouseX, int mouseY, float tick) {
        this.GUI = gui;
        this.font = font;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tick = tick;
    }

    public GuiGraphics getGuiGraphics() {
        return this.GUI;
    }

    public Font getFont() {
        return this.font;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public float getTick() {
        return this.tick;
    }

    public void blit(ResourceLocation texture, int x, int y, float u, float v, int uvMaxX, int uvMaxY, int maxX, int maxY) {
        this.drawPreparedTexture(texture, x, x + uvMaxX, y, y + uvMaxY, u / (float)maxX, (u + (float)uvMaxX) / (float)maxX, v / (float)maxY, (v + (float)uvMaxY) / (float)maxY);
    }

    public void blitMonoImage(ResourceLocation resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.blit(resourceLocation, x, y, 0.0f, 0.0f, maxSizeX, maxSizeY, maxSizeX, maxSizeY);
    }

    private void drawPreparedTexture(ResourceLocation texture, int x, int xEnd, int y, int yEnd, float u, float uEnd, float v, float vEnd) {
        Matrix4f matrix4f = this.GUI.m_280168_().m_85850_().m_252922_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(GUI_TEXTURE_WITH_ALPHA.apply(texture));
        vertexconsumer.m_252986_(matrix4f, (float)x, (float)y, 0.0f).m_7421_(u, v).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)x, (float)yEnd, 0.0f).m_7421_(u, vEnd).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)xEnd, (float)yEnd, 0.0f).m_7421_(uEnd, vEnd).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)xEnd, (float)y, 0.0f).m_7421_(uEnd, v).m_5752_();
        this.GUI.m_280262_();
    }

    public void renderTooltip(Component text, int mouseX, int mouseY) {
        this.renderTooltip(List.of(text), mouseX, mouseY);
    }

    public void renderTooltip(List<Component> texts, int mouseX, int mouseY) {
        this.GUI.m_280666_(this.font, texts, mouseX, mouseY);
    }

    public void renderFromSpriteClass(TextureAtlasSprite sprite, int x, int y, int maxSizeX, int maxSizeY, int color) {
        this.GUI.m_280565_(x, y, 0, maxSizeX, maxSizeY, sprite, (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f);
    }

    public void drawString(Component text, int x, int y, int color, boolean useShadow) {
        this.GUI.m_280614_(this.font, text, x, y, color, useShadow);
    }

    public void drawCenteredString(Component text, int xCenter, int y, int color, boolean useShadow) {
        int x = xCenter - this.font.m_92895_(text.getString()) / 2;
        this.drawString(text, x, y, color, useShadow);
    }

    public void drawCenteredStringWithAdditional(Component text, int xCenter, int y, int color, boolean useShadow, BiConsumer<Integer, Integer> additional) {
        int length = this.font.m_92895_(text.getString());
        int x = xCenter - length / 2;
        additional.accept(x, length);
        this.drawString(text, x, y, color, useShadow);
    }

    public void fill(int x, int y, int endX, int endY, int color) {
        this.GUI.m_280509_(x, y, endX, endY, color);
    }

    public void blurScreen(int width, int height, int alpha) {
        this.fill(0, 0, width, height, FastColor.ARGB32.m_13660_((int)alpha, (int)77, (int)77, (int)77));
    }

    public void enableScrissors(int x, int y, int endX, int endY) {
        this.GUI.m_280588_(x, y, endX, endY);
    }

    public void disableScrissors() {
        this.GUI.m_280618_();
    }

    public void renderItem(ItemStack item, float x, float y, float scale, float zDepth) {
        if (scale == 1.0f) {
            scale = 16.0f;
        }
        PoseStack pose = this.GUI.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x + 8.0f, y + 8.0f, 150.0f + zDepth);
        pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pose.m_85841_(scale, scale, scale);
        this.doMainRenderingItem(pose, item);
        pose.m_85849_();
    }

    public void renderInDepthIfNeededAfterBlockRendering(Runnable rendering) {
        PoseStack stack = this.GUI.m_280168_();
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 300.0f);
        rendering.run();
        stack.m_85849_();
    }

    public static void renderOverlay(GuiGraphics gui, float delta) {
        GuiUtils guiUtils = new GuiUtils();
        guiUtils.setGuiGraphics(gui, GuiUtils.MC.f_91062_, -100, -100, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        if (GuiUtils.MC.f_91073_ != null) {
            OVERLAYS.forEach(overlay -> overlay.render(guiUtils, window.m_85445_(), window.m_85446_()));
        }
    }

    private void doMainRenderingItem(PoseStack stack, ItemStack item) {
        boolean bl;
        BakedModel bakedModel = MC.m_91291_().m_174264_(item, (Level)GuiUtils.MC.f_91073_, (LivingEntity)GuiUtils.MC.f_91074_, 0);
        boolean bl2 = bl = !bakedModel.m_7547_();
        if (bl) {
            Lighting.m_84930_();
        }
        MC.m_91291_().m_115143_(item, ItemDisplayContext.GUI, false, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        this.GUI.m_280262_();
        if (bl) {
            Lighting.m_84931_();
        }
    }

    public void renderBlockInGui(BlockState blockState, @Nullable BlockEntity blockEntity, float x, float y, float scale) {
        PoseStack stack = this.GUI.m_280168_();
        stack.m_85836_();
        stack.m_252880_(x, y, 100.0f);
        stack.m_85841_(scale, -scale, scale);
        stack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
        this.renderBlock(stack, blockState, blockEntity != null ? blockEntity.m_58899_() : AIR);
        RenderSystem.setShaderLights((Vector3f)DIFFUSE_LIGHT_START, (Vector3f)DIFFUSE_LIGHT_END);
        this.renderBlockEntity(stack, blockEntity);
        stack.m_85849_();
    }

    private void renderBlock(PoseStack stack, BlockState blockState, BlockPos pos) {
        RandomSource random = RandomSource.m_216335_((long)blockState.m_60726_(pos));
        if (blockState.m_60799_() == RenderShape.MODEL) {
            ClientLevelAccessor acc = ClientLevelAccessor.of((Level)GuiUtils.MC.f_91073_);
            acc.setSpecialRenderingMode(true);
            BakedModel model = blockRenderer.m_110910_(blockState);
            ModelData modeldata = model.getModelData((BlockAndTintGetter)GuiUtils.MC.f_91073_, pos, blockState, ModelData.EMPTY);
            for (RenderType renderType : model.getRenderTypes(blockState, random, modeldata)) {
                VertexConsumer vertex = bufferSource.m_6299_(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
                blockRenderer.m_110937_().tesselateBlock((BlockAndTintGetter)GuiUtils.MC.f_91073_, model, blockState, pos, stack, vertex, false, random, blockState.m_60726_(pos), OverlayTexture.f_118083_, modeldata, renderType);
            }
            acc.setSpecialRenderingMode(false);
        }
    }

    private Boolean skipCheckOrContainsRenderer(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            return BE_WITH_RENDERERS.computeIfAbsent(block, b -> {
                BlockEntity ent = entityBlock.m_142194_(AIR, state);
                if (ent == null) {
                    return false;
                }
                return blockEntityRenderer.m_112265_(ent) != null;
            });
        }
        return null;
    }

    public void renderAdditionalOnBlock(BlockState blockState, float x, float y, float scale) {
        Boolean result = this.skipCheckOrContainsRenderer(blockState);
        if (!(blockState.m_60799_() != RenderShape.INVISIBLE || result != null && result.booleanValue())) {
            Item item = null;
            if (blockState.m_60734_() instanceof LiquidBlock) {
                item = blockState.m_60819_().m_76152_().m_6859_();
            } else if (blockState.m_60734_().m_5456_() != Items.f_41852_) {
                item = blockState.m_60734_().m_5456_();
            }
            if (item != null) {
                ItemStack itemStack = new ItemStack((ItemLike)item);
                CompoundTag blockstate = NbtUtils.m_129202_((BlockState)blockState);
                CompoundTag properties = blockstate.m_128469_("Properties");
                itemStack.m_41700_("BlockStateTag", (Tag)properties);
                this.renderItem(itemStack, x, y, scale, 100.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BlockEntity> void renderBlockEntity(PoseStack stack, T blockEntity) {
        BlockEntityRenderer renderer;
        if (blockEntity != null && (renderer = blockEntityRenderer.m_112265_(blockEntity)) != null) {
            ClientLevelAccessor acc = ClientLevelAccessor.of((Level)GuiUtils.MC.f_91073_);
            try {
                acc.setSpecialRenderingMode(true);
                renderer.m_6922_(blockEntity, this.tick, stack, (MultiBufferSource)bufferSource, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
            }
            catch (Exception exception) {
            }
            finally {
                acc.setSpecialRenderingMode(false);
            }
        }
    }

    public static boolean isMouseOver(int x, int y, int endX, int endY, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)endX && mouseY >= (double)y && mouseY < (double)endY;
    }

    public static boolean isInBounds(Rect2i box, double mouseX, double mouseY) {
        return GuiUtils.isMouseOver(box.m_110085_(), box.m_110086_(), box.m_110085_() + box.m_110090_(), box.m_110086_() + box.m_110091_(), mouseX, mouseY);
    }

    public static void playClickSound() {
        MC.m_91106_().m_120367_(GuiUtils.getClickSound());
    }

    public static SoundInstance getClickSound() {
        return SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f);
    }

    public static void pushHotbarMessage(Component text) {
        GuiUtils.MC.f_91065_.m_93063_(text, false);
        MC.m_240477_().m_168785_(text);
    }

    static {
        bufferSource = MC.m_91269_().m_110104_();
        blockRenderer = MC.m_91289_();
        blockEntityRenderer = MC.m_167982_();
        Matrix4f matrix4f = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-2.41661f, 2.3561945f, 0.0f);
        DIFFUSE_LIGHT_START = matrix4f.transformDirection((Vector3fc)new Vector3f(0.2f, 1.0f, -0.7f).normalize(), new Vector3f());
        DIFFUSE_LIGHT_END = matrix4f.transformDirection((Vector3fc)new Vector3f(-0.2f, 1.0f, 0.7f).normalize(), new Vector3f());
        OVERLAYS.add(new PlayerCrackOverlay());
        OVERLAYS.add(new BlockHeartOverlay());
    }
}

