/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ListenerEditBox
extends EditBox {
    public static final ResourceLocation EDITBOX_BORDER_SPRITE = GuiUtils.res("textures/screens/editbox.png");
    public static final ResourceLocation VANILLA = GuiUtils.vanillaRes("");
    private final ResourceLocation borderTexture;
    private final GuiUtils gui = new GuiUtils();
    private final Font font;
    private final Consumer<String> action;
    protected boolean editable = true;
    private final boolean borderLock;

    public ListenerEditBox(Font font, int x, int y, int length, int height, Component name, Consumer<String> action, @Nullable ResourceLocation border) {
        super(font, x, y, length, height, name);
        this.action = action;
        this.font = font;
        this.borderTexture = border;
        this.m_94182_(border != null);
        this.borderLock = true;
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        return this.check(() -> super.m_7933_(key, scancode, mods));
    }

    public boolean m_5534_(char character, int mods) {
        return this.check(() -> super.m_5534_(character, mods));
    }

    private boolean check(BooleanSupplier input) {
        if (this.f_93623_ && this.f_93624_ && this.editable && this.m_93696_()) {
            String value = this.m_94155_();
            boolean flag = input.getAsBoolean();
            if (!value.equals(this.m_94155_())) {
                this.action.accept(this.m_94155_());
            }
            return flag;
        }
        return false;
    }

    public void m_94186_(boolean yes) {
        super.m_94186_(yes);
        this.editable = yes;
    }

    public boolean vanillaBorder() {
        return this.borderTexture == VANILLA;
    }

    public int m_94210_() {
        return this.m_5711_() - 8;
    }

    public void m_94182_(boolean value) {
        if (!this.borderLock) {
            super.m_94182_(value);
        }
    }

    public void m_87963_(GuiGraphics g, int mouseX, int mouseY, float ticks) {
        if (this.borderTexture != null && this.borderTexture != VANILLA) {
            this.gui.setGuiGraphics(g, this.font, mouseX, mouseY, ticks);
            this.gui.blit(this.borderTexture, this.m_252754_(), this.m_252907_(), 0.0f, this.editable ? 0.0f : (float)this.m_93694_(), this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_() * 2);
        }
        super.m_87963_(g, mouseX, mouseY, ticks);
    }
}

