/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import java.util.List;
import java.util.function.IntSupplier;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ScrollerManager<T> {
    private static final ResourceLocation SPRITE_WITH_SCROLLER = GuiUtils.vanillaRes("textures/gui/container/creative_inventory/tabs.png");
    private static final CustomBarData VANILLA_SCROLLBAR = new CustomBarData(null, 12, 15);
    @Nullable
    private List<T> list;
    private final IntSupplier barX;
    private final IntSupplier barY;
    private final int row;
    private final int column;
    private final int barHeight;
    private final List<T> renderable;
    protected float scrollOffset = 0.0f;
    private boolean scrollWork;
    private final CustomBarData data;

    public ScrollerManager(IntSupplier barX, IntSupplier barY, int height, int row, int column, List<T> renderable, @Nullable CustomBarData data) {
        this.renderable = renderable;
        this.barHeight = height;
        this.barX = barX;
        this.barY = barY;
        this.row = row;
        this.column = column;
        this.data = data == null ? VANILLA_SCROLLBAR : data;
    }

    public boolean canScroll() {
        if (this.list == null) {
            return false;
        }
        return this.list.size() > this.row * this.column;
    }

    public void renderScroller(GuiUtils gui) {
        if (this.data == VANILLA_SCROLLBAR) {
            gui.blit(SPRITE_WITH_SCROLLER, this.barX.getAsInt(), this.barY.getAsInt() + (int)((float)(this.barHeight - 15) * this.scrollOffset), 232 + (this.canScroll() ? 0 : 12), 0.0f, 12, 15, 256, 256);
        } else {
            gui.blit(this.data.barSprite(), this.barX.getAsInt(), this.barY.getAsInt() + (int)((float)(this.barHeight - this.data.barHeight) * this.scrollOffset), 0.0f, this.canScroll() ? 0.0f : (float)this.data.barHeight, this.data.barLength, this.data.barHeight, this.data.barLength, this.data.barHeight * 2);
        }
    }

    public void setMainList(@Nullable List<T> main) {
        this.list = main;
    }

    public List<T> getMainList() {
        return this.list;
    }

    public void setScrollOffset(float i) {
        this.scrollOffset = Mth.m_14036_((float)i, (float)0.0f, (float)1.0f);
    }

    public float getScrollerOffset() {
        return this.scrollOffset;
    }

    private int findRowNumber() {
        return Mth.m_184652_((int)(this.list != null ? this.list.size() : 0), (int)this.row) - this.column;
    }

    protected int findRowIndexForScrollOffset(float f) {
        return Math.max((int)((double)(f * (float)this.findRowNumber()) + 0.5), 0);
    }

    public boolean mouseClicked(double x, double y) {
        if (x > (double)this.barX.getAsInt() && x < (double)(this.barX.getAsInt() + this.data.barLength + 1) && y > (double)this.barY.getAsInt() && y < (double)(this.barY.getAsInt() + this.barHeight)) {
            this.scrollWork = this.canScroll();
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseY) {
        if (this.scrollWork) {
            float barHeight = this.data.barHeight;
            float scroll = ((float)mouseY - (float)this.barY.getAsInt() - barHeight / 2.0f) / ((float)this.barHeight - barHeight);
            this.scrollOffset = Mth.m_14036_((float)scroll, (float)0.0f, (float)1.0f);
            this.refreshList();
            return true;
        }
        return false;
    }

    public void disableScrollWork() {
        this.scrollWork = false;
    }

    public boolean mouseScrolled(double yScrolled) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffset = Mth.m_14036_((float)(this.scrollOffset - (float)(yScrolled / (double)this.findRowNumber())), (float)0.0f, (float)1.0f);
        this.refreshList();
        return true;
    }

    public void refreshList() {
        this.renderable.clear();
        if (this.list != null && !this.list.isEmpty()) {
            int i = this.findRowIndexForScrollOffset(this.scrollOffset);
            int startIndex = i * this.row;
            for (int j = 0; j < this.column; ++j) {
                int index;
                for (int k = 0; k < this.row && (index = k + j * this.row + startIndex) < this.list.size(); ++k) {
                    this.renderable.add(this.list.get(index));
                }
            }
        }
    }

    public record CustomBarData(ResourceLocation barSprite, int barLength, int barHeight) {
    }
}

