/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import java.util.function.Supplier;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SpriteImageButton
extends Button {
    private final GuiUtils utils = new GuiUtils();
    private final ResourceLocation sprite;
    private final Supplier<Boolean> activated;
    private final boolean useInActive;
    private final int u;
    private final int v;
    private final int maxU;
    private final int maxV;

    public SpriteImageButton(int x, int y, int lengthButtonOnScreen, int heightButtonOnScreen, ResourceLocation sprite, Button.OnPress onPress, @Nullable Supplier<Boolean> active, boolean useInActive) {
        super(x, y, lengthButtonOnScreen, heightButtonOnScreen, CommonComponents.f_237098_, onPress, f_252438_);
        this.sprite = sprite;
        this.activated = active;
        this.useInActive = useInActive;
        this.u = 0;
        this.v = 0;
        this.maxU = this.m_5711_();
        this.maxV = this.m_93694_() * (useInActive ? 3 : 2);
    }

    public SpriteImageButton(int x, int y, int lengthButtonOnScreen, int heightButtonOnScreen, ResourceLocation sprite, Button.OnPress onPress, @Nullable Supplier<Boolean> active, boolean useInActive, int u, int v, int maxU, int maxV) {
        super(x, y, lengthButtonOnScreen, heightButtonOnScreen, CommonComponents.f_237098_, onPress, f_252438_);
        this.sprite = sprite;
        this.activated = active;
        this.useInActive = useInActive;
        this.u = u;
        this.v = v;
        this.maxV = maxV;
        this.maxU = maxU;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.activated != null) {
            this.f_93623_ = this.activated.get();
        }
        this.utils.setGuiGraphics(guiGraphics, Minecraft.m_91087_().f_91062_, mouseX, mouseY, delta);
        int y = 0;
        if (!this.f_93623_) {
            if (!this.useInActive) throw new IllegalArgumentException("Button disabled, but sprite not contains INACTIVE texture!");
            y = this.m_93694_() * 2;
        } else if (this.f_93622_) {
            y = this.m_93694_();
        }
        this.utils.blit(this.sprite, this.m_252754_(), this.m_252907_(), this.u, this.v + y, this.m_5711_(), this.m_93694_(), this.maxU, this.maxV);
    }
}

