/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.Objects;
import java.util.function.Consumer;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class BlockInPlayer2 {
    private final InPlayerBlockPos offset;
    private final BlockPos pos;
    private final Player player;
    private BlockState blockState;
    private BlockEntity blockEntity;
    private BlockEntityTicker blockEntityTicker;
    private ModelData data = ModelData.EMPTY;

    public BlockInPlayer2(PlayerAccessor pl, InPlayerBlockPos pos, BlockState state, Consumer<BlockInPlayer2> preInit) {
        this.offset = pos;
        this.pos = pos.boundedBlockPos(pl.player());
        if (this.pos == null) {
            throw new IllegalArgumentException("Null BlockPos in BlockInPlayer! Player section: " + BlockPosBounds.getChunkPosForPlayer(pl.player()) + " Level: " + pl.player().m_9236_());
        }
        this.player = pl.player();
        this.blockState = state;
        preInit.accept(this);
        this.initBlockEntity();
        this.initTicker();
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public InPlayerBlockPos getOffset() {
        return this.offset;
    }

    protected boolean shouldShowFluidState() {
        return Config.getInstance().getValue("liquidsInBlocks", Boolean.class);
    }

    public boolean shouldDoFluidAction() {
        return this.blockState.m_60734_() instanceof LiquidBlock || !this.blockState.m_60819_().m_76178_() && this.shouldShowFluidState();
    }

    @Nullable
    public Throwable loadNBT(CompoundTag tg) {
        if (this.blockEntity != null) {
            try {
                this.blockEntity.m_142466_(tg);
            }
            catch (Throwable e) {
                return e;
            }
        }
        return null;
    }

    public BlockInPlayer2 handleClientTag(CompoundTag tg, ClientBoundMorphUpdatePacket pkt) {
        if (this.blockEntity != null) {
            try {
                this.blockEntity.onDataPacket(pkt.getListener().m_104910_(), ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this.blockEntity, ent -> tg));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public void onPlace(BlockState newState, BlockState oldState, boolean update) {
        if (!this.player.m_9236_().f_46443_) {
            newState.m_60696_(this.player.m_9236_(), this.pos, oldState, update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockInPlayer2 changeBlockState(BlockState state, boolean update) {
        BlockState old = this.blockState;
        this.blockState = state;
        if (!this.player.m_9236_().f_46443_) {
            try {
                old.m_60753_(this.player.m_9236_(), this.pos, state, update);
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while removing block in morphed player on pos: {} for block: {} on player: {}", new Object[]{this.offset, old, this.player.m_7755_().getString(), e});
            }
            finally {
                if (this.needRemoveBlockEntity(old, state)) {
                    this.clearBlockEntity();
                }
            }
        } else if (this.needRemoveBlockEntity(old, state)) {
            this.clearBlockEntity();
        }
        this.onPlace(state, old, update);
        if (state.m_155947_()) {
            if (this.blockEntity == null) {
                this.initBlockEntity();
            } else {
                this.blockEntity.m_155250_(state);
            }
        }
        this.initTicker();
        return this;
    }

    public void clearBlockEntity() {
        this.blockEntity = null;
        this.blockEntityTicker = null;
    }

    private void initBlockEntity() {
        Block block = this.blockState.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            this.blockEntity = ent.m_142194_(this.pos, this.blockState);
            if (this.blockEntity != null) {
                this.blockEntity.m_142339_(this.player.m_9236_());
                this.blockEntity.onLoad();
            }
        }
    }

    private void initTicker() {
        Block block = this.blockState.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            if (this.blockEntity != null) {
                this.blockEntityTicker = ent.m_142354_(this.player.m_9236_(), this.blockState, this.blockEntity.m_58903_());
            }
        }
    }

    public void connectModelData(ModelData data) {
        this.data = Objects.requireNonNullElse(data, ModelData.EMPTY);
    }

    public ModelData getModelData() {
        return this.data;
    }

    public void tick() {
        if (this.blockEntity != null && this.blockEntityTicker != null) {
            try {
                this.blockEntityTicker.m_155252_(this.player.m_9236_(), this.pos, this.blockState, this.blockEntity);
            }
            catch (Exception e) {
                this.blockEntityTicker = null;
                MorphUtils.LOGGER.error("An unexpected exception occurred while ticking a block entity in a transformed player with username " + this.player.m_7755_().getString() + ": ", (Throwable)e);
            }
        }
    }

    public void animateTick(RandomSource randomSource, Block marker, Consumer<BlockState> needSpawnFluidDrip) {
        FluidState fluidState;
        if (this.player.m_9236_().f_46443_) {
            this.blockState.m_60734_().m_214162_(this.blockState, this.player.m_9236_(), this.pos, randomSource);
        }
        if (this.shouldDoFluidAction() && !(fluidState = this.blockState.m_60819_()).m_76178_()) {
            fluidState.m_230558_(this.player.m_9236_(), this.pos, randomSource);
            needSpawnFluidDrip.accept(PlayerAccessor.of(this.player).getBlockState(this.offset.offset(0, -1, 0)));
        }
        if (this.blockState.m_60734_() == marker) {
            Vec3 real = MorphUtils.getCetneredRealBlockPos(PlayerAccessor.of(this.player), this.offset);
            this.player.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, this.blockState), real.f_82479_, real.f_82480_, real.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private boolean needRemoveBlockEntity(BlockState old, BlockState newState) {
        return old.m_155947_() && (!old.m_60713_(newState.m_60734_()) || !newState.m_155947_());
    }
}

