/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.dataSyncher.TagSyncedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ChairController {
    private final Entity owner;
    private final TagSyncedData CHAIR_DATA;
    private BlockState chairBlockstate;
    private InPlayerBlockPos realPos;

    public ChairController(Entity owner) {
        this.owner = owner;
        this.CHAIR_DATA = new TagSyncedData(owner, MorphUtils.res("chair_data"), new CompoundTag(), this::onDataReceived);
    }

    public CompoundTag getTagData() {
        return (CompoundTag)this.CHAIR_DATA.get();
    }

    public void tick() {
        Entity entity;
        if (!this.owner.m_9236_().f_46443_ && (entity = this.owner.m_20202_()) instanceof PlayerAccessor) {
            BlockState state;
            PlayerAccessor pl = (PlayerAccessor)entity;
            if (!((CompoundTag)this.CHAIR_DATA.get()).m_128456_() && (state = this.chairBlockstate) != null && !pl.getBlockState(this.realPos).m_60734_().equals(state.m_60734_())) {
                this.owner.m_8127_();
            }
        }
    }

    public void onStopRiding() {
        if (!this.owner.m_9236_().f_46443_) {
            Entity entity = this.owner.m_20202_();
            if (entity instanceof PlayerAccessor) {
                BlockState state2;
                BlockState state;
                PlayerAccessor pl = (PlayerAccessor)entity;
                if (!((CompoundTag)this.CHAIR_DATA.get()).m_128456_() && (state = this.chairBlockstate) != null && !state.equals(state2 = this.findOccupied(state))) {
                    pl.setBlockState(this.realPos, state2, false);
                }
            }
            this.CHAIR_DATA.set(new CompoundTag());
        }
    }

    public Entity replaceEntityOnMorphedPlayer(Entity entity) {
        AtomicReference<Entity> chair = new AtomicReference<Entity>(entity);
        Vec3 pos = EntityAccessor.of(entity).getMorphedPos();
        if (pos != null && this.isChair(entity)) {
            InPlayerBlockPos.check(BlockPos.m_274446_((Position)pos), (pl, realPos) -> {
                chair.set((Entity)pl.player());
                CompoundTag tg = new CompoundTag();
                double yOffset = pos.f_82480_ + entity.m_6048_() + this.owner.m_6049_();
                tg.m_128347_("x", pos.f_82479_);
                tg.m_128347_("y", yOffset);
                tg.m_128347_("z", pos.f_82481_);
                tg.m_128365_("Chair", (Tag)NbtUtils.m_129202_((BlockState)pl.getBlockState((InPlayerBlockPos)realPos)));
                tg.m_128359_("RealPos", realPos.string());
                this.CHAIR_DATA.set(tg);
                entity.m_146870_();
            }, null, (LevelReader)this.owner.m_9236_());
        }
        return chair.get();
    }

    private boolean isChair(Entity ent) {
        Mob mob;
        return ent.f_19794_ || ent instanceof Mob && (mob = (Mob)ent).m_21525_() || !ent.m_6000_(ent.m_20185_(), ent.m_20186_(), ent.m_20189_());
    }

    private BlockState findOccupied(BlockState state) {
        for (Property prop : state.m_61147_()) {
            BooleanProperty bProp;
            if (!(prop instanceof BooleanProperty) || !(bProp = (BooleanProperty)prop).m_61708_().equalsIgnoreCase("occupied")) continue;
            return (BlockState)state.m_61124_((Property)bProp, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void onDataReceived() {
        CompoundTag tg = (CompoundTag)this.CHAIR_DATA.get();
        if (tg.m_128456_()) {
            this.chairBlockstate = null;
            this.realPos = null;
        } else {
            this.chairBlockstate = NbtUtils.m_247651_((HolderGetter)this.owner.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tg.m_128469_("Chair"));
            this.realPos = InPlayerBlockPos.parseBlockPos(tg.m_128461_("RealPos"));
        }
    }
}

