/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HitBoxCalculator {
    private InPlayerBlockPos minPos = InPlayerBlockPos.get(0, 0, 0);
    private InPlayerBlockPos maxPos = InPlayerBlockPos.get(0, 0, 0);
    private final PlayerAccessor pl;

    public HitBoxCalculator(PlayerAccessor owner) {
        this.pl = owner;
    }

    public InPlayerBlockPos getMinPos() {
        return this.minPos;
    }

    public InPlayerBlockPos getMaxPos() {
        return this.maxPos;
    }

    public void recalculatePositions() {
        this.minPos = this.findMinPos();
        this.maxPos = this.findMaxPos();
    }

    private AABB centerAABB(AABB original, Vec3 center) {
        double width = original.f_82291_ - original.f_82288_;
        double height = original.f_82292_ - original.f_82289_;
        double depth = original.f_82293_ - original.f_82290_;
        return new AABB(center.f_82479_ - width / 2.0, center.f_82480_, center.f_82481_ - depth / 2.0, center.f_82479_ + width / 2.0, center.f_82480_ + height, center.f_82481_ + depth / 2.0);
    }

    private InPlayerBlockPos findMinPos() {
        if (this.pl.getBlocksData2().isEmpty()) {
            return InPlayerBlockPos.ZERO;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (InPlayerBlockPos pos : this.pl.getBlocksData2().keySet()) {
            if (pos.getX() < minX) {
                minX = pos.getX();
            }
            if (pos.getY() < minY) {
                minY = pos.getY();
            }
            if (pos.getZ() >= minZ) continue;
            minZ = pos.getZ();
        }
        return InPlayerBlockPos.get(minX, minY, minZ);
    }

    private InPlayerBlockPos findMaxPos() {
        if (this.pl.getBlocksData2().isEmpty()) {
            return InPlayerBlockPos.get(1, 1, 1);
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (InPlayerBlockPos pos : this.pl.getBlocksData2().keySet()) {
            if (pos.getX() > maxX) {
                maxX = pos.getX();
            }
            if (pos.getY() > maxY) {
                maxY = pos.getY();
            }
            if (pos.getZ() <= maxZ) continue;
            maxZ = pos.getZ();
        }
        return InPlayerBlockPos.get(maxX, maxY, maxZ).offset(1, 1, 1);
    }

    public EntityDimensions calculateDimensions() {
        return new EntityDimensions(0.0f, 0.0f, false){

            public AABB m_20384_(double d, double e, double f) {
                Vec3 vec3 = new Vec3(d, e, f);
                AABB ab = new AABB(vec3.f_82479_ + (double)HitBoxCalculator.this.minPos.getX(), vec3.f_82480_ + (double)HitBoxCalculator.this.minPos.getY(), vec3.f_82481_ + (double)HitBoxCalculator.this.minPos.getZ(), vec3.f_82479_ + (double)HitBoxCalculator.this.maxPos.getX(), vec3.f_82480_ + (double)HitBoxCalculator.this.maxPos.getY(), vec3.f_82481_ + (double)HitBoxCalculator.this.maxPos.getZ());
                return HitBoxCalculator.this.centerAABB(ab, vec3);
            }
        };
    }

    public float getEyeHeight() {
        return (float)(this.maxPos.getY() - 1) + 0.83300006f + (this.pl.player().m_6047_() ? -0.125f : 0.0f);
    }
}

