/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.DataResult;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blockomorph.Blockomorph;
import net.blockomorph.command.BlockmorphCommand;
import net.blockomorph.command.BlockmorphconfigCommand;
import net.blockomorph.core.KeyMappings;
import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.network.ClientBoundConfigUpdatePacket;
import net.blockomorph.network.MainPacket;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDrownEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber
public class MorphUtils {
    public static final ResourceKey<DamageType> PLAYER_DESTROYED = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)MorphUtils.res("player_destroyed"));
    public static final ResourceKey<DamageType> PLAYER_DESTROYED_NULL = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)MorphUtils.res("player_destroyed_null"));
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"blockomorph");
    private static final HashMap<ResourceLocation, PacketInfo> handlers = new HashMap();

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static ResourceLocation res(String path) {
        return new ResourceLocation("blockomorph", path);
    }

    public static ResourceLocation vanillaRes(String path) {
        return new ResourceLocation("minecraft", path);
    }

    public static PacketInfo getHandler(ResourceLocation id) {
        return handlers.get(id);
    }

    public static void sendServer(BlockMorphPacket packet) {
        Blockomorph.PACKET_HANDLER.sendToServer((Object)new MainPacket(packet));
    }

    public static void sendAll(BlockMorphPacket packet) {
        Blockomorph.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new MainPacket(packet));
    }

    public static void sendPlayer(BlockMorphPacket packet, ServerPlayer pl) {
        Blockomorph.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new MainPacket(packet));
    }

    public static void registerPacket(String id, Function<FriendlyByteBuf, BlockMorphPacket> bl, boolean client) {
        ResourceLocation res = MorphUtils.res(id);
        if (handlers.containsKey(res)) {
            throw new IllegalArgumentException("Packet with Id: " + id + " alredy registered!");
        }
        handlers.put(res, new PacketInfo(bl, client));
    }

    public static void doBlockInMorphedPlayerOnPos(@Nullable Entity self, Iterable<Entity> entities, Vec3 pos, BiConsumer<PlayerAccessor, BlockInPlayer2> action) {
        for (Entity entity : entities) {
            PlayerAccessor pl;
            if (entity == self || !(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive() || !entity.m_20191_().m_82390_(pos)) continue;
            pl.getBlocksData2InArea(new AABB(pos, pos), (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(blockOffset, block, realPos) -> action.accept(pl, (BlockInPlayer2)block)));
        }
    }

    public static boolean needModedHit(Predicate<Class<?>> predicate) {
        Optional findedClazz;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile && (findedClazz = STACK_WALKER.walk(stackFrameStream -> stackFrameStream.skip(1L).filter(frame -> predicate.test(frame.getDeclaringClass())).findFirst().map(StackWalker.StackFrame::getDeclaringClass))).isPresent()) {
            return !Projectile.class.isAssignableFrom((Class)findedClazz.get());
        }
        return true;
    }

    public static Predicate<String> blockPredicate() {
        return value -> {
            DataResult result = ResourceLocation.m_135837_((String)value);
            if (result.result().isPresent()) {
                return ForgeRegistries.BLOCKS.containsKey((ResourceLocation)result.result().get());
            }
            return false;
        };
    }

    @SubscribeEvent
    public static void run(ServerStartingEvent event) {
        Config.setServer(event.getServer());
        BlockPosBounds.load();
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        BlockmorphconfigCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        BlockmorphCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MorphUtils.sendPlayer(new ClientBoundConfigUpdatePacket(Config.getInstance()), player);
        PlayerAccessor.of((Player)player).sendAllContentToPlayer(player);
    }

    public static Vec3 getRealBlockPos(PlayerAccessor original, InPlayerBlockPos offset) {
        return MorphUtils.getRealBlockPos(original, new Vec3((double)offset.x, (double)offset.y, (double)offset.z));
    }

    public static Vec3 getRealBlockPos(PlayerAccessor original, Vec3 offset) {
        AABB aabb = original.player().m_20191_();
        InPlayerBlockPos minPos = original.minPos();
        double deltaX = offset.f_82479_ - (double)minPos.getX();
        double deltaY = offset.f_82480_ - (double)minPos.getY();
        double deltaZ = offset.f_82481_ - (double)minPos.getZ();
        double globalX = aabb.f_82288_ + deltaX;
        double globalY = aabb.f_82289_ + deltaY;
        double globalZ = aabb.f_82290_ + deltaZ;
        return new Vec3(globalX, globalY, globalZ);
    }

    public static void distanceTo(Vec3 from, Vec3 to, boolean sqr, double offset, DoubleConsumer action) {
        if (InPlayerBlockPos.isMorphedPlayerX(from.f_82479_) || InPlayerBlockPos.isMorphedPlayerX(to.f_82479_) && action != null) {
            from = InPlayerBlockPos.checkOnReal(from);
            to = InPlayerBlockPos.checkOnReal(to);
            double d0 = from.f_82479_ + offset - to.f_82479_;
            double d1 = from.f_82480_ + offset - to.f_82480_;
            double d2 = from.f_82481_ + offset - to.f_82481_;
            double result = d0 * d0 + d1 * d1 + d2 * d2;
            if (!sqr) {
                result = Math.sqrt(result);
            }
            action.accept(result);
        }
    }

    public static void executeMorphedBlockShapeUpdate(LevelAccessor level, Direction direction, BlockState state, BlockPos offsetted, BlockPos origin, int flags, int distance, BlockState external) {
        BlockState blockstate1 = external.m_60728_(direction, state, level, offsetted, origin);
        Block.m_49908_((BlockState)external, (BlockState)blockstate1, (LevelAccessor)level, (BlockPos)offsetted, (int)flags, (int)distance);
    }

    public static Vec3 getCetneredRealBlockPos(PlayerAccessor original, InPlayerBlockPos offset) {
        Vec3 vec = MorphUtils.getRealBlockPos(original, offset);
        return new Vec3(vec.f_82479_ + 0.5, vec.f_82480_ + 0.5, vec.f_82481_ + 0.5);
    }

    public static boolean isAdventureCanBreak(PlayerAccessor pl, Player attacker, InPlayerBlockPos hitPart) {
        BlockInPlayer2 block = pl.getBlocksData2().get(hitPart);
        if (block != null) {
            BlockInWorld blockinworld = new BlockInWorld((LevelReader)pl.player().m_9236_(), block.getPos(), true);
            ItemStack itemstack = attacker.m_21205_();
            Registry registry = attacker.m_9236_().m_9598_().m_175515_(Registries.f_256747_);
            return !itemstack.m_41619_() && (itemstack.m_204128_(registry, blockinworld) || itemstack.m_204121_(registry, blockinworld));
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingAttackEvent event) {
        LivingEntity attacked = event.getEntity();
        DamageSource damage = event.getSource();
        if (attacked instanceof PlayerAccessor) {
            boolean allowed;
            PlayerAccessor pl = (PlayerAccessor)attacked;
            if (damage.m_7640_() instanceof Player ? Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand : damage.m_7640_() instanceof Projectile && Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile) {
                return;
            }
            boolean noTnt = pl.getTnt() == null;
            boolean tntBlock = pl.getBlockState(InPlayerBlockPos.ZERO).m_60734_() instanceof TntBlock;
            boolean tntDamage = damage.m_276093_(DamageTypes.f_268448_) || damage.m_276093_(DamageTypes.f_268565_);
            boolean bl = allowed = damage.m_276093_(DamageTypes.f_286979_) || damage.m_276093_(DamageTypes.f_268724_);
            if (pl.isActive()) {
                if (!damage.m_276093_(PLAYER_DESTROYED) && !damage.m_276093_(PLAYER_DESTROYED_NULL)) {
                    event.setCanceled(true);
                }
                if (allowed || !tntBlock && tntDamage) {
                    MorphUtils.destroy(pl, damage.m_7639_());
                } else if (tntBlock && tntDamage && noTnt) {
                    pl.setTnt();
                    PrimedTnt tnt = pl.getTnt();
                    if (tnt != null) {
                        tnt.m_32085_(tnt.m_32100_() / 2);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDrown(LivingDrownEvent event) {
        PlayerAccessor pl;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof PlayerAccessor && (pl = (PlayerAccessor)livingEntity).isActive()) {
            event.setDrowning(false);
        }
    }

    public static boolean needRejectUse(Level lv, BlockHitResult block) {
        if (InPlayerBlockPos.isMorphedPlayerX(block.m_82425_().m_123341_())) {
            BlockState state = lv.m_8055_(block.m_82425_());
            Config.UseMode mode = Config.getInstance().getValue("useMode", Config.UseMode.class);
            switch (mode) {
                case DISABLED: {
                    return true;
                }
                case VANILLA: {
                    ResourceLocation res = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                    return res != null && !res.m_135827_().equals("minecraft");
                }
            }
        }
        return false;
    }

    public static UseOnContext checkOnRealIfOut(UseOnContext ctx, ItemStack stack) {
        Config.PlaceMode mode;
        if (stack.m_41720_() instanceof BlockItem && InPlayerBlockPos.isMorphedPlayerX(ctx.m_8083_().m_123341_()) && (mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class)) == Config.PlaceMode.OUT) {
            Vec3 realHit = InPlayerBlockPos.checkOnReal(ctx.m_43720_());
            realHit = MorphUtils.toDirection(realHit, ctx.m_43719_());
            BlockHitResult hit = new BlockHitResult(realHit, ctx.m_43719_(), BlockPos.m_274446_((Position)realHit), ctx.m_43721_());
            return new UseOnContext(ctx.m_43725_(), ctx.m_43723_(), ctx.m_43724_(), ctx.m_43722_(), hit);
        }
        return ctx;
    }

    private static Vec3 toDirection(Vec3 vec, Direction dir) {
        Vec3i step = dir.m_122436_();
        double x = switch (step.m_123341_()) {
            case 1 -> Math.ceil(vec.f_82479_) + 1.0E-7;
            case -1 -> Math.floor(vec.f_82479_) - 1.0E-7;
            default -> vec.f_82479_;
        };
        double y = switch (step.m_123342_()) {
            case 1 -> Math.ceil(vec.f_82480_) + 1.0E-7;
            case -1 -> Math.floor(vec.f_82480_) - 1.0E-7;
            default -> vec.f_82480_;
        };
        double z = switch (step.m_123343_()) {
            case 1 -> Math.ceil(vec.f_82481_) + 1.0E-7;
            case -1 -> Math.floor(vec.f_82481_) - 1.0E-7;
            default -> vec.f_82481_;
        };
        return new Vec3(x, y, z);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Config.PlaceMode mode;
        if (event.getEntity().m_21120_(event.getHand()).m_41720_() instanceof BlockItem && (mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class)) == Config.PlaceMode.DISABLED && InPlayerBlockPos.isMorphedPlayerX(event.getHitVec().m_82425_().m_123341_())) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canOpenMenuIn(PlayerAccessor pl, InPlayerBlockPos offset) {
        BlockInPlayer2 block = pl.getBlocksData2().get(offset);
        if (block != null) {
            MenuProvider pr = block.getBlockState().m_60750_(pl.player().m_9236_(), block.getPos());
            return pr != null;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canOpenConfig() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91074_ != null && mc.f_91074_.m_20310_(2) && Config.getInstance().getValue("canOperatorModifyConfig", Boolean.class) != false;
    }

    public static Config.ScreenAccess getScreenAccess(Player player) {
        if (player != null && player.m_20310_(2)) {
            return Config.ScreenAccess.ALL;
        }
        return Config.getInstance().getValue("screenAccess", Config.ScreenAccess.class);
    }

    public static void destroy(PlayerAccessor mob_pl, @Nullable Entity attacker) {
        Player mob = (Player)mob_pl;
        Set<TagKey> type = Set.of(DamageTypeTags.f_268738_, DamageTypeTags.f_268630_, DamageTypeTags.f_268437_, DamageTypeTags.f_273918_, DamageTypeTags.f_268413_, DamageTypeTags.f_276146_, DamageTypeTags.f_268490_);
        Holder.Reference damage = mob.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(attacker == null ? PLAYER_DESTROYED_NULL : PLAYER_DESTROYED);
        damage.m_205769_(type);
        mob.m_6469_(new DamageSource((Holder)damage, attacker), Float.MAX_VALUE);
    }

    public record PacketInfo(Function<FriendlyByteBuf, BlockMorphPacket> packet, boolean isClient) {
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            KeyMappings.registerKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        }
    }
}

