/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.accessors.LevelRendererAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.VertexConsumerWrapper;
import org.joml.Vector4f;

public class MorphedPlayerRenderer {
    private final Minecraft mc = Minecraft.m_91087_();
    private final BlockRenderDispatcher blockRenderDispatcher = this.mc.m_91289_();
    private final EntityRenderDispatcher entityDispatcher = this.mc.m_91290_();
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher = this.mc.m_167982_();
    private final MultiBufferSource crumblBuffer = this.mc.m_91269_().m_110108_();
    private final RandomSource RANDOM = RandomSource.m_216327_();

    public boolean render(boolean translucent, AbstractClientPlayer player, float anim, float partialticks, PoseStack posestack, MultiBufferSource buffer, int light, Consumer<Float> shadow) {
        if (player instanceof PlayerAccessor) {
            PlayerAccessor pl = (PlayerAccessor)player;
            if (pl.isFullActive()) {
                shadow.accept(Float.valueOf(0.0f));
                posestack.m_85836_();
                this.adjustMatrixForPlayer(posestack, pl, player);
                this.renderBlock(translucent, player, posestack, buffer, pl);
                this.renderBlockEntity(player, partialticks, posestack, buffer, pl);
                this.renderBreak(player, posestack, buffer, pl);
                this.renderFrame(posestack, buffer, pl);
                posestack.m_85849_();
                return true;
            }
            if (pl.getTnt() != null && !translucent) {
                this.renderTnt(player, anim, partialticks, posestack, buffer, light, pl);
                return true;
            }
        }
        return false;
    }

    private void renderTnt(AbstractClientPlayer player, float anim, float partialticks, PoseStack posestack, MultiBufferSource buffer, int light, PlayerAccessor pl) {
        PrimedTnt tnt = pl.getTnt();
        EntityRenderer rend = this.entityDispatcher.m_114382_((Entity)pl.getTnt());
        try {
            rend.m_7392_((Entity)tnt, anim, partialticks, posestack, buffer, light);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void adjustMatrixForPlayer(PoseStack poseStack, PlayerAccessor pl, AbstractClientPlayer player) {
        InPlayerBlockPos minpos = pl.minPos();
        AABB hitbox = player.m_20191_();
        Vec3 playerCenter = player.m_20182_();
        double offsetX = hitbox.f_82288_ - (playerCenter.f_82479_ + (double)minpos.getX());
        double offsetZ = hitbox.f_82290_ - (playerCenter.f_82481_ + (double)minpos.getZ());
        poseStack.m_85837_(offsetX, 0.0, offsetZ);
    }

    private BlockPos getPosForOffset(BlockInPlayer2 ctr) {
        return ctr.getPos();
    }

    public void renderBlock(boolean translucent, AbstractClientPlayer player, PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            BlockInPlayer2 bl = entry.getValue();
            BlockState st = bl.getBlockState();
            InPlayerBlockPos pos = entry.getKey();
            posestack.m_85836_();
            posestack.m_252880_((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if (st.m_60799_() == RenderShape.MODEL) {
                this.renderBlock(translucent, player, st, posestack, buffer, bl, bl.getModelData());
            }
            if (bl.shouldDoFluidAction()) {
                this.renderLiquid(translucent, bl, posestack, buffer, pl);
            }
            posestack.m_85849_();
        }
    }

    private void renderBlock(boolean translucent, AbstractClientPlayer player, BlockState blockstate, PoseStack posestack, MultiBufferSource buffer, BlockInPlayer2 block, ModelData data) {
        Level level = player.m_9236_();
        BakedModel model = this.blockRenderDispatcher.m_110910_(blockstate);
        BlockPos offset = this.getPosForOffset(block);
        ModelData modeldata = model.getModelData((BlockAndTintGetter)level, block.getPos(), blockstate, data);
        for (RenderType renderType : model.getRenderTypes(blockstate, this.RANDOM, modeldata)) {
            if (translucent != (renderType == RenderType.m_110466_())) {
                return;
            }
            VertexConsumer vertex = buffer.m_6299_(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
            this.blockRenderDispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, blockstate, offset, posestack, vertex, true, this.RANDOM, blockstate.m_60726_(offset), OverlayTexture.f_118083_, modeldata, renderType);
        }
    }

    private void renderLiquid(boolean translucent, BlockInPlayer2 block, final PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        FluidState fluidState = block.getBlockState().m_60819_();
        if (!fluidState.m_76178_()) {
            BlockPos pos = block.getPos();
            RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
            if (renderType == RenderType.m_110466_()) {
                renderType = RenderType.m_110469_();
            }
            if (translucent != (renderType == RenderType.m_110469_())) {
                return;
            }
            final float xOffset = pos.m_123341_() & 0xF;
            final float yOffset = pos.m_123342_() & 0xF;
            final float zOffset = pos.m_123343_() & 0xF;
            VertexConsumerWrapper vertexConsumer = new VertexConsumerWrapper(buffer.m_6299_(renderType)){

                public VertexConsumer m_5483_(double x, double y, double z) {
                    Vector4f realPos = posestack.m_85850_().m_252922_().transform(new Vector4f((float)(x - (double)xOffset), (float)(y - (double)yOffset), (float)(z - (double)zOffset), 1.0f));
                    return super.m_5483_((double)realPos.x(), (double)realPos.y(), (double)realPos.z());
                }
            };
            ClientLevelAccessor acc = ClientLevelAccessor.of(pl.player().m_9236_());
            try {
                acc.lockExternalMorphedBlockGetter(true);
                this.blockRenderDispatcher.m_234363_(pos, (BlockAndTintGetter)pl.player().m_9236_(), (VertexConsumer)vertexConsumer, block.getBlockState(), fluidState);
                acc.lockExternalMorphedBlockGetter(false);
            }
            catch (ReportedException reportedException) {
                // empty catch block
            }
        }
    }

    private void renderBlockEntity(AbstractClientPlayer player, float partialticks, PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            InPlayerBlockPos pos = entry.getKey();
            posestack.m_85836_();
            posestack.m_252880_((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            this.renderBlockEntity(entry.getValue(), player, partialticks, posestack, buffer, this.getRenderLight(player, this.getPosForOffset(entry.getValue())), pl);
            posestack.m_85849_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockEntity(BlockInPlayer2 data, AbstractClientPlayer player, float partialticks, PoseStack posestack, MultiBufferSource buffer, int light, PlayerAccessor pl) {
        BlockEntity blockEntity = data.getBlockEntity();
        if (blockEntity != null) {
            posestack.m_85836_();
            try {
                BlockEntityRenderer renderer = this.blockEntityRenderDispatcher.m_112265_(blockEntity);
                if (renderer != null) {
                    MultiBufferSource src = buffer;
                    int k = this.getBrakeProgress(pl, blockEntity.m_58899_());
                    if (k > -1 && k < 10) {
                        PoseStack.Pose posestack$pose = posestack.m_85850_();
                        SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(this.crumblBuffer.m_6299_((RenderType)ModelBakery.f_119229_.get(k)), posestack$pose.m_252922_(), posestack$pose.m_252943_(), 1.0f);
                        src = arg_0 -> MorphedPlayerRenderer.lambda$renderBlockEntity$0(buffer, (VertexConsumer)vertexconsumer, arg_0);
                    }
                    ClientLevelAccessor acc = ClientLevelAccessor.of(blockEntity.m_58904_());
                    acc.setSpecialRenderingMode(true);
                    renderer.m_6922_(blockEntity, partialticks, posestack, src, light, OverlayTexture.f_118083_);
                    acc.setSpecialRenderingMode(false);
                }
            }
            catch (Exception exception) {
            }
            finally {
                posestack.m_85849_();
            }
        }
    }

    private int getRenderLight(AbstractClientPlayer entity, BlockPos blockPos) {
        Level lv = entity.m_9236_();
        return LightTexture.m_109885_((int)lv.m_45517_(LightLayer.BLOCK, blockPos), (int)lv.m_45517_(LightLayer.SKY, blockPos));
    }

    private void renderBreak(AbstractClientPlayer player, PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        for (BlockInPlayer2 block : pl.getBlocksData2().values()) {
            BlockState state = block.getBlockState();
            if (state.m_60799_() != RenderShape.MODEL) continue;
            int k = this.getBrakeProgress(pl, block.getPos());
            posestack.m_85836_();
            InPlayerBlockPos offset = block.getOffset();
            posestack.m_252880_((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
            this.renderBreak(k, state, player, posestack, buffer, block.getModelData(), block);
            posestack.m_85849_();
        }
    }

    private int getBrakeProgress(PlayerAccessor pl, BlockPos bounded) {
        if (Config.getInstance().getValue("hitReaction", Config.HitReaction.class) != Config.HitReaction.BRAKING) {
            Player player = pl.player();
            float percentage = player.m_21223_() / player.m_21233_();
            if ((double)percentage < 0.03) {
                return 9;
            }
            int k = Mth.m_14167_((float)(percentage * 10.0f));
            return 9 - k;
        }
        return MorphedPlayerRenderer.getBrakeProgress(bounded);
    }

    public static int getBrakeProgress(BlockPos bounded) {
        BlockDestructionProgress progress;
        LevelRendererAccessor acc = LevelRendererAccessor.of(Minecraft.m_91087_().f_91060_);
        SortedSet pos = (SortedSet)acc.getBrakingBlocks().get(bounded.m_121878_());
        if (pos != null && (progress = (BlockDestructionProgress)pos.last()) != null) {
            return progress.m_139988_();
        }
        return -1;
    }

    private void renderBreak(int k, BlockState blockstate, AbstractClientPlayer player, PoseStack posestack, MultiBufferSource buffer, ModelData data, BlockInPlayer2 block) {
        posestack.m_85836_();
        PoseStack.Pose posestack$pose1 = posestack.m_85850_();
        if (k > -1 && k < 10) {
            SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(this.crumblBuffer.m_6299_((RenderType)ModelBakery.f_119229_.get(k)), posestack$pose1.m_252922_(), posestack$pose1.m_252943_(), 1.0f);
            BlockPos offset = this.getPosForOffset(block);
            this.blockRenderDispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)player.m_9236_(), this.blockRenderDispatcher.m_110910_(blockstate), blockstate, offset, posestack, (VertexConsumer)vertexconsumer1, false, this.RANDOM, blockstate.m_60726_(offset), OverlayTexture.f_118083_, data, null);
        }
        posestack.m_85849_();
    }

    private void renderFrame(PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        MorphedPlayerHitResult hit = this.shouldRenderFrame(pl);
        if (hit != null) {
            posestack.m_85836_();
            VoxelShape shape = pl.getRenderShape(hit.getOffset(), (Player)this.mc.f_91074_);
            if (shape == null) {
                posestack.m_85849_();
                return;
            }
            LevelRendererAccessor.of(this.mc.f_91060_).renderBlockHitbox(posestack, buffer.m_6299_(RenderType.m_110504_()), shape, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, 0.4f);
            posestack.m_85849_();
        }
    }

    private MorphedPlayerHitResult shouldRenderFrame(PlayerAccessor pl) {
        HitResult hitResult = this.mc.f_91077_;
        if (hitResult instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult hit = (MorphedPlayerHitResult)hitResult;
            if (!this.mc.f_91066_.f_92062_ && hit.getPlayer() == pl) {
                if (this.mc.f_91074_.m_5833_()) {
                    return MorphUtils.canOpenMenuIn(hit.getPlayer(), hit.getOffset()) ? hit : null;
                }
                if (this.mc.f_91072_.m_105295_() == GameType.ADVENTURE) {
                    return MorphUtils.isAdventureCanBreak(hit.getPlayer(), (Player)this.mc.f_91074_, hit.getOffset()) ? hit : null;
                }
                return hit;
            }
        }
        return null;
    }

    private static /* synthetic */ VertexConsumer lambda$renderBlockEntity$0(MultiBufferSource buffer, VertexConsumer vertexconsumer, RenderType p_234298_) {
        VertexConsumer vertexconsumer2 = buffer.m_6299_(p_234298_);
        return p_234298_.m_110405_() ? VertexMultiConsumer.m_86168_((VertexConsumer)vertexconsumer, (VertexConsumer)vertexconsumer2) : vertexconsumer2;
    }
}

