/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import net.blockomorph.utils.PlayerAccessor;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovementCalculator {
    private final Player player;
    private final Level level;
    private final Direction lookDirection;
    private final AABB aabb;
    private final boolean error;

    public MovementCalculator(PlayerAccessor playerAccessor) {
        this.player = playerAccessor.player();
        this.level = this.player.m_9236_();
        this.lookDirection = this.player.m_6350_();
        this.aabb = this.player.m_20191_();
        this.error = this.lookDirection == Direction.DOWN || this.lookDirection == Direction.UP;
    }

    public void calculateEnterCorrection(Vec3 originalMovement) {
        double d0 = 1.0100000000000002E-5;
        if (this.error || originalMovement.f_82479_ == 0.0 && originalMovement.f_82481_ == 0.0) {
            return;
        }
        AABB main = null;
        Vec3 movement = new Vec3(d0 * (double)this.lookDirection.m_122429_(), 0.0, d0 * (double)this.lookDirection.m_122431_());
        for (VoxelShape shp : this.level.m_186431_((Entity)this.player, this.aabb.m_82383_(movement))) {
            for (AABB aabb : shp.m_83299_()) {
                if (!this.aabb.m_82383_(movement).m_82381_(aabb) || main != null && !this.isCloser(aabb, main, originalMovement)) continue;
                main = aabb;
            }
        }
        if (main == null) {
            return;
        }
        Vec3 offset = this.getHitBoxOffset(main, originalMovement);
        if (this.level.m_45756_((Entity)this.player, this.aabb.m_82383_(offset).m_82383_(movement)) && this.isGoodPath(main, originalMovement)) {
            this.player.m_6034_(offset.f_82479_ + this.player.m_20185_(), this.player.m_20186_(), offset.f_82481_ + this.player.m_20189_());
        }
    }

    private boolean isGoodPath(AABB b, Vec3 m) {
        Direction dir = this.lookDirection;
        AABB playerBox = this.aabb;
        if (dir == Direction.NORTH) {
            if (m.f_82479_ > 0.0) {
                return playerBox.f_82288_ + m.f_82479_ > b.f_82291_;
            }
            return playerBox.f_82291_ + m.f_82479_ < b.f_82288_;
        }
        if (dir == Direction.SOUTH) {
            if (m.f_82479_ < 0.0) {
                return playerBox.f_82291_ + m.f_82479_ < b.f_82288_;
            }
            return playerBox.f_82288_ + m.f_82479_ > b.f_82291_;
        }
        if (dir == Direction.WEST) {
            if (m.f_82481_ > 0.0) {
                return playerBox.f_82290_ + m.f_82481_ > b.f_82293_;
            }
            return playerBox.f_82293_ + m.f_82481_ < b.f_82290_;
        }
        if (dir == Direction.EAST) {
            if (m.f_82481_ < 0.0) {
                return playerBox.f_82293_ + m.f_82481_ < b.f_82290_;
            }
            return playerBox.f_82290_ + m.f_82481_ > b.f_82293_;
        }
        throw new IllegalArgumentException("Wrong side: " + dir);
    }

    private boolean isCloser(AABB a, AABB b, Vec3 m) {
        Direction dir = this.lookDirection;
        boolean flag = false;
        if (dir == Direction.NORTH) {
            boolean bl = flag = a.f_82291_ < b.f_82291_;
            if (m.f_82479_ > 0.0) {
                flag = !flag;
            }
        } else if (dir == Direction.SOUTH) {
            boolean bl = flag = a.f_82288_ > b.f_82288_;
            if (m.f_82479_ < 0.0) {
                flag = !flag;
            }
        } else if (dir == Direction.WEST) {
            boolean bl = flag = a.f_82293_ < b.f_82293_;
            if (m.f_82481_ > 0.0) {
                flag = !flag;
            }
        } else if (dir == Direction.EAST) {
            boolean bl = flag = a.f_82290_ > b.f_82290_;
            if (m.f_82481_ < 0.0) {
                flag = !flag;
            }
        }
        return flag;
    }

    private Vec3 getHitBoxOffset(AABB main, Vec3 m) {
        Direction dir = this.lookDirection;
        AABB playerBox = this.aabb;
        if (dir == Direction.NORTH) {
            if (m.f_82479_ > 0.0) {
                return new Vec3(main.f_82291_ - playerBox.f_82288_, 0.0, 0.0);
            }
            return new Vec3(main.f_82288_ - playerBox.f_82291_, 0.0, 0.0);
        }
        if (dir == Direction.SOUTH) {
            if (m.f_82479_ < 0.0) {
                return new Vec3(main.f_82288_ - playerBox.f_82291_, 0.0, 0.0);
            }
            return new Vec3(main.f_82291_ - playerBox.f_82288_, 0.0, 0.0);
        }
        if (dir == Direction.WEST) {
            if (m.f_82481_ > 0.0) {
                return new Vec3(0.0, 0.0, main.f_82293_ - playerBox.f_82290_);
            }
            return new Vec3(0.0, 0.0, main.f_82290_ - playerBox.f_82293_);
        }
        if (dir == Direction.EAST) {
            if (m.f_82481_ < 0.0) {
                return new Vec3(0.0, 0.0, main.f_82290_ - playerBox.f_82293_);
            }
            return new Vec3(0.0, 0.0, main.f_82293_ - playerBox.f_82290_);
        }
        throw new IllegalArgumentException("Wrong side: " + dir);
    }
}

