/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public class SavedBlockManager {
    private final Path gameDir;
    private boolean init;
    private final HashMap<String, SavedBlock> blocks = new HashMap();

    public SavedBlockManager(Path gameDir) {
        this.gameDir = gameDir.resolve("saved_blocks.bmdat");
    }

    public void load() {
        if (!this.init) {
            try {
                CompoundTag tag = NbtIo.m_128953_((File)this.gameDir.toFile());
                if (tag != null) {
                    for (String key : tag.m_128431_()) {
                        this.blocks.put(key, SavedBlock.fromTag(tag.m_128469_(key), key));
                    }
                }
                this.init = true;
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while loading saved blocks", (Throwable)e);
            }
        }
    }

    public HashMap<String, SavedBlock> get() {
        return this.blocks;
    }

    public void delete(String s) {
        if (this.blocks.containsKey(s)) {
            this.blocks.remove(s);
            this.write();
        }
    }

    public void add(SavedBlock b) {
        String s = b.getName();
        if (!this.blocks.containsKey(s)) {
            this.blocks.put(s, b);
            this.write();
        }
    }

    public void clear() {
        this.blocks.clear();
        this.write();
    }

    public void write() {
        try {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<String, SavedBlock> entry : this.blocks.entrySet()) {
                tag.m_128365_(entry.getKey(), (Tag)entry.getValue().toNbt());
            }
            NbtIo.m_128955_((CompoundTag)tag, (File)this.gameDir.toFile());
        }
        catch (Exception e) {
            MorphUtils.LOGGER.error("An error occurred while saving favourite blocks", (Throwable)e);
        }
    }
}

