/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Predicate;
import net.blockomorph.screens.config.renderers.BlockListConfigRenderer;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BlockListConfig
extends ConfigInstance<List<String>> {
    private static BlockListConfigRenderer RENDERER;
    private final ListOptionContext context;

    public BlockListConfig(String name, List<String> initialValue, boolean canOperatorModify, @Nullable Component tip, ListOptionContext ctx) {
        super(name, initialValue, canOperatorModify, tip);
        this.context = ctx;
    }

    @Override
    public void readFromStorage(JsonElement option) {
        for (JsonElement el : option.getAsJsonArray()) {
            ((List)this.value).add(el.getAsString());
        }
    }

    @Override
    public JsonElement getDataForStorage() {
        JsonArray jsonArray = new JsonArray();
        for (String item : (List)this.value) {
            jsonArray.add(item);
        }
        return jsonArray;
    }

    @Override
    public void readFromNetwork(FriendlyByteBuf buf) {
        ((List)this.value).clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String element = buf.m_130277_();
            ((List)this.value).add(element);
        }
    }

    @Override
    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.writeInt(((List)this.value).size());
        for (String element : (List)this.value) {
            buf.m_130070_(element);
        }
    }

    public ResourceLocation getFrameTexture() {
        return this.context.frame;
    }

    @Override
    public void parseFromUser(String value) {
        String action;
        String[] parts = value.split(" ", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid input format: " + value);
        }
        String element = parts[1];
        switch (action = parts[0]) {
            case "+": {
                if (this.context.allowedAddValue != null && this.context.allowedAddValue.test(element)) {
                    if (((List)this.value).contains(element)) break;
                    ((List)this.value).add(element);
                    break;
                }
                this.throwError(action, element);
            }
            case "-": {
                if (this.context.allowedRemoveValue != null && this.context.allowedRemoveValue.test(element)) {
                    ((List)this.value).remove(element);
                    break;
                }
                this.throwError(action, element);
            }
            case "r": {
                if (this.context.canClear) {
                    ((List)this.value).clear();
                    break;
                }
                this.throwError(action, element);
            }
            default: {
                throw new IllegalArgumentException("Invalid action: " + action);
            }
        }
    }

    private void throwError(String option, String value) {
        throw new IllegalArgumentException("Invalid action: " + option + " for value: " + value);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> buildArgument(LiteralArgumentBuilder<CommandSourceStack> optionNameArgument, CommandBuildContext context, Commands.CommandSelection environment) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)optionNameArgument.then(this.end((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"add"), false, context))).then(this.end((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"remove"), true, context))).then(Commands.m_82127_((String)"clear").executes(args -> {
            ((List)this.value).clear();
            Config.getInstance().writeAndSend();
            ((CommandSourceStack)args.getSource()).m_288197_(() -> Component.m_237110_((String)"blockomorph.commands.option_change.list.clear", (Object[])new Object[]{this.name}), true);
            return 1;
        }));
    }

    private LiteralArgumentBuilder<CommandSourceStack> end(LiteralArgumentBuilder<CommandSourceStack> actionString, boolean remove, CommandBuildContext ctx) {
        return (LiteralArgumentBuilder)actionString.then(Commands.m_82129_((String)"value", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)ctx, (ResourceKey)Registries.f_256747_)).executes(args -> {
            MutableComponent end;
            String name = ResourceArgument.m_246781_((CommandContext)args, (String)"value", (ResourceKey)Registries.f_256747_).m_205785_().m_135782_().toString();
            if (remove) {
                end = Component.m_237110_((String)"blockomorph.commands.option_change.list.remove", (Object[])new Object[]{name, this.name});
                ((List)this.value).remove(name);
            } else {
                if (!((List)this.value).contains(name)) {
                    ((List)this.value).add(name);
                }
                end = Component.m_237110_((String)"blockomorph.commands.option_change.list.add", (Object[])new Object[]{name, this.name});
            }
            Config.getInstance().writeAndSend();
            ((CommandSourceStack)args.getSource()).m_288197_(() -> BlockListConfig.lambda$end$2((Component)end), true);
            return 1;
        }));
    }

    @Override
    public Command<CommandSourceStack> buildGetter() {
        return args -> {
            ((CommandSourceStack)args.getSource()).m_288197_(() -> Component.m_237110_((String)"blockomorph.commands.option_get.list", (Object[])new Object[]{this.name, ((List)this.value).size(), ((List)this.value).toString()}), true);
            return 1;
        };
    }

    public BlockListConfigRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new BlockListConfigRenderer();
        }
        return RENDERER;
    }

    private static /* synthetic */ Component lambda$end$2(Component end) {
        return end;
    }

    public record ListOptionContext(ResourceLocation frame, @Nullable Predicate<String> allowedAddValue, @Nullable Predicate<String> allowedRemoveValue, boolean canClear) {
    }
}

