/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.blockomorph.screens.config.renderers.BooleanConfigRenderer;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class BooleanConfig
extends ConfigInstance<Boolean> {
    private static BooleanConfigRenderer RENDERER;

    public BooleanConfig(String name, Boolean initialValue, boolean canOperatorModify, @Nullable Component tip) {
        super(name, initialValue, canOperatorModify, tip);
    }

    @Override
    public void readFromStorage(JsonElement option) {
        this.value = option.getAsBoolean();
    }

    @Override
    public JsonElement getDataForStorage() {
        return new JsonPrimitive((Boolean)this.value);
    }

    @Override
    public void parseFromUser(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    @Override
    public void readFromNetwork(FriendlyByteBuf buf) {
        this.value = buf.readBoolean();
    }

    @Override
    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(((Boolean)this.value).booleanValue());
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> buildArgument(LiteralArgumentBuilder<CommandSourceStack> optionNameArgument, CommandBuildContext context, Commands.CommandSelection environment) {
        return (LiteralArgumentBuilder)optionNameArgument.then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(args -> {
            this.value = BoolArgumentType.getBool((CommandContext)args, (String)"value");
            Config.getInstance().writeAndSend();
            ((CommandSourceStack)args.getSource()).m_288197_(() -> Component.m_237110_((String)"blockomorph.commands.option_change.default", (Object[])new Object[]{this.name, ((Boolean)this.value).toString()}), true);
            return 1;
        }));
    }

    public BooleanConfigRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new BooleanConfigRenderer();
        }
        return RENDERER;
    }
}

