/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blockomorph.screens.config.renderers.CategoryConfigRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtPath;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CategoryOption
extends ConfigInstance<List<ConfigInstance<?>>> {
    private static CategoryConfigRenderer RENDERER;

    public CategoryOption(String name, List<ConfigInstance<?>> options, @Nullable Component tip, boolean hidedCategory) {
        super(name, Collections.unmodifiableList(options), !hidedCategory, tip);
        if (options.isEmpty()) {
            throw new IllegalArgumentException("Option list must not be empty!");
        }
    }

    @Override
    public List<ConfigInstance<?>> getEnterableInstances() {
        return (List)this.value;
    }

    @Override
    public void readFromStorage(JsonElement option) {
        JsonObject object = option.getAsJsonObject();
        for (ConfigInstance instance : (List)this.value) {
            instance.readFromStorage(object.get(instance.getName()));
        }
    }

    @Override
    public JsonElement getDataForStorage() {
        JsonObject object = new JsonObject();
        for (ConfigInstance instance : (List)this.value) {
            object.add(instance.getName(), instance.getDataForStorage());
        }
        return object;
    }

    @Override
    public void parseFromUser(String value) {
        throw new UnsupportedOperationException("You can't change the value of a category property directly, you need to specify the specific property name in the category.");
    }

    @Override
    public void readFromNetwork(FriendlyByteBuf buf) {
        for (ConfigInstance instance : (List)this.value) {
            instance.readFromNetwork(buf);
        }
    }

    @Override
    public void writeToNetwork(FriendlyByteBuf buf) {
        for (ConfigInstance instance : (List)this.value) {
            instance.writeToNetwork(buf);
        }
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> buildArgument(LiteralArgumentBuilder<CommandSourceStack> optionNameArgument, CommandBuildContext context, Commands.CommandSelection environment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Command<CommandSourceStack> buildGetter() {
        throw new UnsupportedOperationException();
    }

    public CategoryConfigRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new CategoryConfigRenderer();
        }
        return RENDERER;
    }

    @Override
    public List<ConfigInstance<?>> setValue(List<ConfigInstance<?>> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean trySetValue(ConfigInstance<?> instance) {
        boolean result = true;
        if (instance instanceof CategoryOption) {
            CategoryOption option = (CategoryOption)instance;
            for (ConfigInstance configInstance : (List)option.value) {
                ConfigInstance<?> finded = this.findOptionByName(configInstance.getName());
                if (finded != null) {
                    if (finded.trySetValue(configInstance)) continue;
                    result = false;
                    continue;
                }
                result = false;
            }
        } else {
            return false;
        }
        return result;
    }

    @Nullable
    private ConfigInstance<?> findOptionByName(String name) {
        for (ConfigInstance configInstance : (List)this.value) {
            if (!configInstance.getName().equals(name)) continue;
            return configInstance;
        }
        return null;
    }

    public record MovingFixer(NbtPath source) implements ConfigInstance.DataFixer<List<ConfigInstance<?>>>
    {
        @Override
        public List<ConfigInstance<?>> fix(ConfigInstance<List<ConfigInstance<?>>> configInstance, JsonElement root, Runnable rewriteStart) {
            JsonElement element = root;
            for (String folder : this.source.constructPath(new ArrayList<String>())) {
                if (!element.isJsonObject()) {
                    return null;
                }
                if ((element = element.getAsJsonObject().get(folder)) != null) continue;
                return null;
            }
            if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                for (ConfigInstance<?> instance : configInstance.getValue()) {
                    try {
                        JsonElement property = object.get(instance.getName());
                        if (property == null) continue;
                        instance.readFromStorage(property);
                    }
                    catch (Exception exception) {}
                }
                rewriteStart.run();
            }
            return null;
        }
    }
}

