/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blockomorph.network.ClientBoundConfigUpdatePacket;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtPath;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.config.BlockListConfig;
import net.blockomorph.utils.config.BooleanConfig;
import net.blockomorph.utils.config.CategoryOption;
import net.blockomorph.utils.config.ConfigInstance;
import net.blockomorph.utils.config.EnumConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class Config {
    private static final Gson WRITER = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = MorphUtils.getGameDir().resolve("config").resolve("blockomorph.json").toFile();
    private static Config INSTANCE;
    private static MinecraftServer SERVER;
    public final List<ConfigInstance<?>> OPTIONS = List.of(new CategoryOption("access", List.of(new EnumConfig<Mode>("listMode", Mode.NONE, true, null), new BlockListConfig("allowedBlocks", new ArrayList<String>(), true, null, new BlockListConfig.ListOptionContext(MorphUtils.res("textures/screens/sel_good.png"), MorphUtils.blockPredicate(), MorphUtils.blockPredicate(), true)), new BlockListConfig("bannedBlocks", new ArrayList<String>(), true, null, new BlockListConfig.ListOptionContext(MorphUtils.res("textures/screens/sel_bad.png"), MorphUtils.blockPredicate(), MorphUtils.blockPredicate(), true)), new BooleanConfig("solidBlocksOnly", false, true, null), new BooleanConfig("offUnbreakableBlocks", false, true, null), new EnumConfig<ScreenAccess>("screenAccess", ScreenAccess.ALL, true, null)), null, false).boundDataFixer(new CategoryOption.MovingFixer(new NbtPath.RootNbtPath())), new CategoryOption("blockBehaviour", List.of(new EnumConfig<UseMode>("useMode", UseMode.ALL, true, null), new EnumConfig<PlaceMode>("placeMode", PlaceMode.OUT, true, null), new EnumConfig<HitReaction>("hitReaction", HitReaction.BRAKING, true, null), new BooleanConfig("entityInside", true, true, (Component)Component.m_237115_((String)"blockomorph.config_option.entityInside.tooltip")), new BooleanConfig("liquidsInBlocks", false, true, (Component)Component.m_237115_((String)"blockomorph.config_option.liquidsInBlocks.tooltip")), new BooleanConfig("blockClientParticles", true, true, null)), null, false).boundDataFixer(new CategoryOption.MovingFixer(new NbtPath.RootNbtPath())), new BooleanConfig("playerDieAfterDestroy", true, true, null), new BooleanConfig("canOperatorModifyConfig", true, false, null));
    private final List<ConfigInstance<?>> ALL_OPTIONS = this.getAllOptions(this.OPTIONS, new ArrayList(), false);
    private final List<ConfigInstance<?>> ALL_OPTIONS_WITH_CATEGORY;

    public static void dummyInit() {
        INSTANCE = new Config();
    }

    private Config() {
        ArrayList names = new ArrayList();
        this.ALL_OPTIONS_WITH_CATEGORY = this.getAllOptions(this.OPTIONS, new ArrayList(), true);
        this.ALL_OPTIONS_WITH_CATEGORY.forEach(option -> {
            if (names.contains(option.getName())) {
                throw new IllegalStateException("Duplicate name for option: " + option.getName());
            }
            names.add(option.getName());
        });
    }

    public static Config getInstance() {
        if (INSTANCE == null) {
            throw new IllegalAccessError("Config not loaded!");
        }
        return INSTANCE;
    }

    public static void loadExternal(Config cfg) {
        if (INSTANCE == null) {
            INSTANCE = new Config();
        }
        for (ConfigInstance<?> instance : cfg.OPTIONS) {
            ConfigInstance<?> realInstance = INSTANCE.getOption(instance.getName(), true);
            if (realInstance.trySetValue(instance)) continue;
            MorphUtils.LOGGER.error("Option with name: {} throw error then setting value: {}", (Object)instance.getName(), instance.value);
        }
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    public static void setServer(MinecraftServer sv) {
        SERVER = sv;
    }

    public void writeAndSend() {
        this.write();
        MorphUtils.sendAll(new ClientBoundConfigUpdatePacket(this));
    }

    public static void load() {
        INSTANCE = new Config();
        if (!Files.exists(CONFIG_FILE.toPath(), new LinkOption[0])) {
            INSTANCE.write();
            return;
        }
        MutableBoolean needUpdate = new MutableBoolean();
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG_FILE));){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (ConfigInstance<?> option : Config.INSTANCE.OPTIONS) {
                JsonElement property = jsonObject.get(option.getName());
                if (property != null) {
                    option.readFromStorage(property);
                }
                option.fixOldData((JsonElement)jsonObject, () -> ((MutableBoolean)needUpdate).setTrue());
            }
        }
        catch (Exception e) {
            MorphUtils.LOGGER.error("Cannot read Blockomorph config: ", (Throwable)e);
        }
        if (needUpdate.booleanValue()) {
            INSTANCE.write();
        }
    }

    protected void write() {
        JsonObject jsonObject = new JsonObject();
        for (ConfigInstance<?> option : this.OPTIONS) {
            jsonObject.add(option.getName(), option.getDataForStorage());
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            WRITER.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (IOException e) {
            MorphUtils.LOGGER.error("Cannot write Blockomorph config, changes lost: ", (Throwable)e);
        }
    }

    public void writeInBuffer(FriendlyByteBuf buf) {
        for (ConfigInstance<?> con : this.OPTIONS) {
            con.writeToNetwork(buf);
        }
    }

    public static Config readFromBuffer(FriendlyByteBuf buf) {
        Config cfg = new Config();
        for (ConfigInstance<?> con : cfg.OPTIONS) {
            con.readFromNetwork(buf);
        }
        return cfg;
    }

    public void parse(String optionName, String value, boolean fromNetwork) {
        ConfigInstance<?> option = this.getOption(optionName, false);
        if (option.getName().equals(optionName) && option.canEditedByOperators()) {
            option.parseFromUser(value);
            this.writeAndSend();
            return;
        }
        if (fromNetwork) {
            throw new IllegalStateException("Invalid option name: " + optionName);
        }
    }

    public <T> T getValue(String optionName, Class<T> valueType) {
        Object value = this.getOption(optionName, false).getValue();
        if (valueType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new IllegalArgumentException("Irregular value type: " + valueType.getTypeName() + " for option: " + optionName);
    }

    private ConfigInstance<?> getOption(String name, boolean includeListsOption) {
        for (ConfigInstance<?> option : includeListsOption ? this.ALL_OPTIONS_WITH_CATEGORY : this.ALL_OPTIONS) {
            if (!option.getName().equals(name)) continue;
            return option;
        }
        throw new IllegalArgumentException("Option not found: " + name);
    }

    private List<ConfigInstance<?>> getAllOptions(List<ConfigInstance<?>> iterable, List<ConfigInstance<?>> collector, boolean includeListsOption) {
        for (ConfigInstance<?> configInstance : iterable) {
            List<ConfigInstance<?>> enterables = configInstance.getEnterableInstances();
            if (!enterables.isEmpty()) {
                this.getAllOptions(enterables, collector, includeListsOption);
                if (!includeListsOption) continue;
                collector.add(configInstance);
                continue;
            }
            collector.add(configInstance);
        }
        return collector;
    }

    public List<ConfigInstance<?>> getAllOptions() {
        return Collections.unmodifiableList(this.ALL_OPTIONS);
    }

    public static enum Mode {
        NONE,
        BLACKLIST,
        WHITELIST;

    }

    public static enum ScreenAccess {
        NONE(false, false),
        MORPH_SCREEN(true, false),
        CONFIG_MORPH_SCREEN(false, true),
        ALL(true, true);

        public final boolean morph;
        public final boolean config;

        private ScreenAccess(boolean morph, boolean config) {
            this.morph = morph;
            this.config = config;
        }
    }

    public static enum UseMode {
        DISABLED,
        VANILLA,
        ALL;

    }

    public static enum PlaceMode {
        DISABLED,
        IN,
        OUT;

    }

    public static enum HitReaction {
        DISABLED(false, false),
        BRAKING(false, false),
        MELEE(true, false),
        PROJECTILES(false, true),
        FULL_PVP(true, true);

        public final boolean hand;
        public final boolean projectile;

        private HitReaction(boolean hand, boolean projectile) {
            this.hand = hand;
            this.projectile = projectile;
        }
    }
}

