/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.blockomorph.screens.config.ConfigRenderer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigInstance<T> {
    private final List<DataFixer<T>> fixers = new ArrayList<DataFixer<T>>();
    protected final String name;
    protected T value;
    private final Component tip;
    private final boolean canOperatorModify;

    protected ConfigInstance(String name, T initialValue, boolean canOperatorModify, @Nullable Component tip) {
        this.name = name;
        this.value = initialValue;
        this.tip = tip;
        this.canOperatorModify = canOperatorModify;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Component getTooltip() {
        return this.tip;
    }

    public abstract void readFromStorage(JsonElement var1);

    public abstract JsonElement getDataForStorage();

    public abstract void parseFromUser(String var1);

    public abstract void readFromNetwork(FriendlyByteBuf var1);

    public abstract void writeToNetwork(FriendlyByteBuf var1);

    public boolean canEditedByOperators() {
        return this.canOperatorModify;
    }

    public abstract LiteralArgumentBuilder<CommandSourceStack> buildArgument(LiteralArgumentBuilder<CommandSourceStack> var1, CommandBuildContext var2, Commands.CommandSelection var3);

    public Command<CommandSourceStack> buildGetter() {
        return args -> {
            ((CommandSourceStack)args.getSource()).m_288197_(() -> Component.m_237110_((String)"blockomorph.commands.option_get.default", (Object[])new Object[]{this.name, this.value.toString()}), true);
            return 1;
        };
    }

    public List<ConfigInstance<?>> getEnterableInstances() {
        return List.of();
    }

    public abstract ConfigRenderer<?> getRenderer();

    public T setValue(T value) {
        this.value = value;
        return this.value;
    }

    public boolean trySetValue(ConfigInstance<?> instance) {
        try {
            this.value = instance.value;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final void fixOldData(JsonElement element, Runnable rewriteStart) {
        for (DataFixer<T> fixer : this.fixers) {
            T value = fixer.fix(this, element, rewriteStart);
            if (value == null) continue;
            this.value = value;
        }
    }

    public final ConfigInstance<T> boundDataFixer(DataFixer<T> fixer) {
        this.fixers.add(fixer);
        return this;
    }

    public T getValue() {
        return this.value;
    }

    @FunctionalInterface
    public static interface DataFixer<VALUE> {
        public VALUE fix(ConfigInstance<VALUE> var1, JsonElement var2, Runnable var3);
    }
}

